package com.walker.pay.payunk.generator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.PayException;
import com.walker.pay.ResponsePay;
import com.walker.pay.payunk.BaseOrderGenerator;
import com.walker.pay.payunk.Constants;
import com.walker.pay.payunk.DefaultPayContext;
import com.walker.pay.payunk.Trans2AlipayResponsePay;
import com.walker.pay.payunk.util.AlipayUtils;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * 代付到支付宝个人账户，生成器实现。
 * @author 时克英
 * @date 2023-10-27
 */
public class Behalf2AlipayOneGenerator extends BaseOrderGenerator {

    public Behalf2AlipayOneGenerator(RestTemplate restTemplate){
        this.setRestTemplate(restTemplate);
    }

    @Override
    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        Trans2AlipayResponsePay responsePay = new Trans2AlipayResponsePay();
        try {
            DefaultPayContext context = (DefaultPayContext) payContext;
//            String pay = JsonUtils.objectToJsonString(AlipayUtils.acquireAliAnDf(context));
            String pay = AlipayUtils.acquireAliAnDfJson(context);
            Map<String, Object> payMap = this.toRequest(context, platformOrder, pay, Constants.PAY_TYPE_BEHALF_ALIPAY_ONE);

            String result = this.sendRequest(PAY_RETURN_JSON_URL, payMap);
            logger.debug(result);

            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode(result);
            if(objectNode.get("code").intValue() != 200){
                String error = objectNode.get("msg").toString();
                logger.error("支付宝个人提现接口错误：{}", error);
                responsePay.setStatus(false);
                responsePay.setMessage(error);
            } else {
                responsePay.setStatus(true);
                responsePay.setMessage("success");
                // 支付宝同步调用，不会返回url参数
//                responsePay.setUrl(objectNode.get("url").toString());
                logger.info("支付宝个人提现接口成功：{}", objectNode);
            }
            return responsePay;

        } catch (Exception ex){
            logger.error("调用支付接口异常，Behalf2AlipayOneGenerator：" + ex.getMessage(), ex);
            if(ex instanceof PayException){
                PayException payException = (PayException) ex;
                responsePay.setStatus(false);
                responsePay.setMessage("转账接口调用失败：" + payException.getMessage() + ", 订单=" + payException.getOrderId());
                return responsePay;
            } else {
                throw new ApplicationRuntimeException("Behalf2AlipayOneGenerator", ex);
            }
        }
    }

    @Deprecated
    @Override
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("方法废弃，请勿调用");
    }
}
