package com.walker.pay.payunk.util;

import com.alibaba.fastjson.JSONObject;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.pay.Order;
import com.walker.pay.payunk.DefaultPayContext;
import com.walker.pay.payunk.extend.AlipayInfo;
import com.walker.pay.payunk.param.AliAnDf;
import com.walker.pay.payunk.param.AlipayReplace;

public class AlipayUtils {

    @Deprecated
    public static final String getAlipayInfo(Order platformOrder){
        AlipayInfo info = new AlipayInfo();
        info.setBody(platformOrder.getAttach());
        info.setTitle(platformOrder.getTitle());
        info.setPayee_account(platformOrder.getBuyerId());  // buyerId字段存：支付宝账号
        info.setPayee_real_name(platformOrder.getNonce());  // nonce字段存：支付宝用户姓名
        try {
            return JsonUtils.objectToJsonString(info);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * 使用对象签名报错，因此使用示例中fastjson直接测试。
     * @param platformOrder
     * @return
     * @date 2023-10-29
     */
    public static final String getAlipayInfoExtendJson(Order platformOrder){
        JSONObject json = new JSONObject(4);
        json.put("body", platformOrder.getAttach());
        json.put("payee_account", platformOrder.getBuyerId());
        json.put("payee_real_name", platformOrder.getNonce());
        json.put("title", platformOrder.getTitle());
        return json.toJSONString();
    }

    /**
     * 支付宝代付到用户，生成字段 pay 的字符串属性。
     * @param context
     * @return
     * @date 2023-10-27
     */
    @Deprecated
    public static final AliAnDf acquireAliAnDf(DefaultPayContext context){
        AliAnDf aliAnDf = new AliAnDf();
        aliAnDf.setAppid("2021002171645503");
        aliAnDf.setIdentity(context.getAlipayIdentity().getStringValue());
        aliAnDf.setAgreement_no(context.getAlipayAgreementNo().getStringValue());
        return aliAnDf;
    }

    public static final String acquireAliAnDfJson(DefaultPayContext context){
        JSONObject json = new JSONObject();
        json.put("appid", "2021002171645503");
        json.put("identity", context.getAlipayIdentity().getStringValue());
        json.put("agreement_no", context.getAlipayAgreementNo().getStringValue());
        return json.toJSONString();
    }

    public static final AlipayReplace acquireAlipayReplace(DefaultPayContext context){
        AlipayReplace replace = new AlipayReplace();
        replace.setAppid(context.getAlipayAppId().getStringValue());
        replace.setRsa_private_key(context.getAlipayRsaPrivateKey().getStringValue());
        replace.setApp_cert_path(context.getAppCertPath().getStringValue());
        replace.setAlipay_cert_path(context.getAlipayCertPath().getStringValue());
        replace.setAlipay_root_cert_path(context.getAlipayRootCertPath().getStringValue());
        return replace;
    }
}
