/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.payunk;

import com.fasterxml.jackson.databind.JsonNode;
import com.walker.infrastructure.utils.MoneyUtils;
import com.walker.pay.AbstractOrderGenerator;
import com.walker.pay.Order;
import com.walker.pay.PayException;
import com.walker.pay.payunk.DefaultPayContext;
import com.walker.pay.payunk.util.AlipayUtils;
import com.walker.pay.payunk.util.SignUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class BaseOrderGenerator
extends AbstractOrderGenerator {
    public static final String PAY_RETURN_JSON_URL = "https://apipay.payunk.cn/pay/index/unifiedorder?format=jsonIn";
    private RestTemplate restTemplate;

    protected String sendRequest(String url, Map<String, Object> payMap) throws PayException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity request = new HttpEntity(payMap, (MultiValueMap)headers);
        ResponseEntity entity = this.getRestTemplate().postForEntity(url, (Object)request, JsonNode.class, new Object[0]);
        this.logger.debug("entity = {}", (Object)entity);
        if (entity.getStatusCodeValue() != 200) {
            throw new PayException(payMap.get("out_trade_no").toString(), "\u8c03\u7528\u8f6c\u8d26\u63a5\u53e3\u5931\u8d25\uff0c" + entity.toString(), null);
        }
        return ((JsonNode)entity.getBody()).toString();
    }

    protected Map<String, Object> toRequest(DefaultPayContext context, Order platformOrder, String payInfo, String providerPayType) {
        HashMap<String, Object> payMap = new HashMap<String, Object>(10);
        payMap.put("appid", context.getAppIdConfig().getStringValue());
        payMap.put("pay_type", providerPayType);
        payMap.put("user_account_id", context.getUserAccountId().getStringValue());
        payMap.put("amount", MoneyUtils.scaleYuan2Accuracy((long)platformOrder.getTotalMoney()));
        payMap.put("callback_url", platformOrder.getNotifyUrl());
        payMap.put("out_trade_no", String.valueOf(platformOrder.getId()));
        payMap.put("pay", payInfo);
        payMap.put("extend", AlipayUtils.getAlipayInfoExtendJson(platformOrder));
        String signStr = SignUtils.signature(payMap);
        payMap.put("sign", signStr);
        return payMap;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

