/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.payunk;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.pay.Order;
import com.walker.pay.OrderGenerator;
import com.walker.pay.OrderStatusQuery;
import com.walker.pay.PayChannel;
import com.walker.pay.PayContext;
import com.walker.pay.PayStatus;
import com.walker.pay.PayType;
import com.walker.pay.ServiceProvider;
import com.walker.pay.payunk.DefaultPayContext;
import com.walker.pay.payunk.generator.Behalf2AlipayOneGenerator;
import com.walker.pay.payunk.generator.Trans2AlipayOneGenerator;
import com.walker.pay.payunk.util.SignUtils;
import com.walker.pay.response.OrderStatusResponsePay;
import com.walker.pay.support.SimplePayEngineProvider;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class PayUnkEngineProvider
extends SimplePayEngineProvider {
    private Map<String, OrderGenerator> orderGeneratorMap = new HashMap<String, OrderGenerator>(8);
    private RestTemplate restTemplate;

    public PayUnkEngineProvider(RestTemplate restTemplate) {
        if (restTemplate == null) {
            throw new IllegalArgumentException("RestTemplate is required!");
        }
        this.restTemplate = restTemplate;
        this.init();
    }

    private void init() {
        this.setServiceProvider(ServiceProvider.PayUnk);
        this.setVersion("v1");
        this.setPayChannel(PayChannel.ProviderDirect);
        Trans2AlipayOneGenerator trans2AlipayOneGenerator = new Trans2AlipayOneGenerator(this.restTemplate);
        this.orderGeneratorMap.put("alipayReplace", (OrderGenerator)trans2AlipayOneGenerator);
        Behalf2AlipayOneGenerator behalf2AlipayOneGenerator = new Behalf2AlipayOneGenerator(this.restTemplate);
        this.orderGeneratorMap.put("aliAnDf", (OrderGenerator)behalf2AlipayOneGenerator);
    }

    protected String acquireProviderPayType(ServiceProvider serviceProvider, PayType payType, PayChannel payChannel) {
        if (payType == PayType.PayUnk_TRANS_ALIPAY_ONE) {
            return "alipayReplace";
        }
        if (payType == PayType.PayUnk_BEHALF_ALIPAY_ONE) {
            return "aliAnDf";
        }
        throw new UnsupportedOperationException("\u4ee3\u7801\u672a\u5b9e\u73b0'\u7545\u8054'\u652f\u4ed8\u7c7b\u578b\u8f6c\u6362:" + payType.getName());
    }

    protected OrderGenerator acquireOrderGenerator(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        return this.orderGeneratorMap.get(providerPayType);
    }

    protected boolean verifySign(Object notifyData) throws Exception {
        return true;
    }

    protected PayContext acquirePayContext(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        DefaultPayContext payContext = new DefaultPayContext();
        payContext.setConfigVariable(configuration.get("pay_unk_appid"));
        payContext.setConfigVariable(configuration.get("pay_unk_account_id"));
        payContext.setConfigVariable(configuration.get("alipay_identity"));
        payContext.setConfigVariable(configuration.get("alipay_agreement_no"));
        return payContext;
    }

    protected OrderStatusQuery acquireOrderStatusQuery(Order order) {
        OrderStatusQuery query = new OrderStatusQuery();
        query.setTradeNo(String.valueOf(order.getId()));
        query.setAppId(((Variable)this.getConfiguration().get("pay_unk_appid")).getStringValue());
        query.setMerchantId(((Variable)this.getConfiguration().get("pay_unk_account_id")).getStringValue());
        return query;
    }

    protected OrderStatusResponsePay invokeOrderStatus(OrderStatusQuery orderStatusQuery) {
        OrderStatusResponsePay responsePay;
        block7: {
            HashMap<String, Object> payMap = new HashMap<String, Object>(10);
            payMap.put("appid", orderStatusQuery.getAppId());
            payMap.put("user_account_id", orderStatusQuery.getMerchantId());
            payMap.put("out_trade_no", orderStatusQuery.getTradeNo());
            String signStr = SignUtils.signature(payMap);
            payMap.put("sign", signStr);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity(payMap, (MultiValueMap)headers);
            ResponseEntity entity = this.restTemplate.postForEntity("https://apipay.payunke.com/pay/index/getorder", (Object)request, String.class, new Object[0]);
            responsePay = new OrderStatusResponsePay();
            String result = (String)entity.getBody();
            try {
                ObjectNode objectNode = JsonUtils.jsonStringToObjectNode((String)result);
                if (objectNode.get("code").intValue() != 200) {
                    String error = objectNode.get("msg").toString();
                    this.logger.error("\u652f\u4ed8\u5b9d\u4e2a\u4eba\u63d0\u73b0\u8ba2\u5355\u67e5\u8be2\u9519\u8bef\uff1a{}", (Object)error);
                    responsePay.setStatus(false);
                    responsePay.setMessage(error);
                    break block7;
                }
                responsePay.setStatus(true);
                JsonNode data = objectNode.get("data");
                int payStatus = data.get("status").intValue();
                if (payStatus == 2 || payStatus == 1) {
                    responsePay.setPayStatus(PayStatus.NotPay);
                    responsePay.setMessage("\u672a\u652f\u4ed8");
                    break block7;
                }
                if (payStatus == 3) {
                    responsePay.setPayStatus(PayStatus.Closed);
                    responsePay.setMessage("\u5df2\u5173\u95ed");
                    break block7;
                }
                if (payStatus == 5) {
                    responsePay.setPayStatus(PayStatus.Refund);
                    responsePay.setMessage("\u5df2\u9000\u6b3e");
                    break block7;
                }
                if (payStatus == 4) {
                    responsePay.setAppId(data.get("appid").toString());
                    responsePay.setOrderId(data.get("out_trade_no").toString());
                    responsePay.setTradeNo(data.get("order_no").toString());
                    responsePay.setPayStatus(PayStatus.Success);
                    responsePay.setPaySuccessTime(data.get("pay_time").toString());
                    responsePay.setMerchantId(data.get("user_account_id").toString());
                    double moneyFen = data.get("amount").doubleValue() * 100.0;
                    responsePay.setTotalMoney((long)moneyFen);
                    break block7;
                }
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u652f\u4ed8\u5b9d\uff08\u8ba2\u5355\u67e5\u8be2\uff09\u8fd4\u56de\u7684\u72b6\u6001\u7c7b\u578b\uff1a" + payStatus);
            }
            catch (Exception e) {
                throw new ApplicationRuntimeException("\u8f6c\u6362'\u67e5\u8be2\u652f\u4ed8\u5b9d\u8f6c\u8d26\u8ba2\u5355'\u9519\u8bef\uff1a" + e.getMessage() + ", " + result, (Throwable)e);
            }
        }
        return responsePay;
    }

    public String generateNotifyResponse(boolean success) {
        if (success) {
            return "success";
        }
        return "failed";
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

