/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.payunk.generator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.PayException;
import com.walker.pay.ResponsePay;
import com.walker.pay.payunk.BaseOrderGenerator;
import com.walker.pay.payunk.DefaultPayContext;
import com.walker.pay.payunk.Trans2AlipayResponsePay;
import com.walker.pay.payunk.util.AlipayUtils;
import java.util.Map;
import org.springframework.web.client.RestTemplate;

public class Behalf2AlipayOneGenerator
extends BaseOrderGenerator {
    public Behalf2AlipayOneGenerator(RestTemplate restTemplate) {
        this.setRestTemplate(restTemplate);
    }

    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        Trans2AlipayResponsePay responsePay = new Trans2AlipayResponsePay();
        try {
            DefaultPayContext context = (DefaultPayContext)payContext;
            String pay = AlipayUtils.acquireAliAnDfJson(context);
            Map<String, Object> payMap = this.toRequest(context, platformOrder, pay, "aliAnDf");
            String result = this.sendRequest("https://apipay.payunk.cn/pay/index/unifiedorder?format=jsonIn", payMap);
            this.logger.debug(result);
            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode((String)result);
            if (objectNode.get("code").intValue() != 200) {
                String error = objectNode.get("msg").toString();
                this.logger.error("\u652f\u4ed8\u5b9d\u4e2a\u4eba\u63d0\u73b0\u63a5\u53e3\u9519\u8bef\uff1a{}", (Object)error);
                responsePay.setStatus(false);
                responsePay.setMessage(error);
            } else {
                responsePay.setStatus(true);
                responsePay.setMessage("success");
                this.logger.info("\u652f\u4ed8\u5b9d\u4e2a\u4eba\u63d0\u73b0\u63a5\u53e3\u6210\u529f\uff1a{}", (Object)objectNode);
            }
            return responsePay;
        }
        catch (Exception ex) {
            this.logger.error("\u8c03\u7528\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38\uff0cBehalf2AlipayOneGenerator\uff1a" + ex.getMessage(), (Throwable)ex);
            if (ex instanceof PayException) {
                PayException payException = (PayException)ex;
                responsePay.setStatus(false);
                responsePay.setMessage("\u8f6c\u8d26\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + payException.getMessage() + ", \u8ba2\u5355=" + payException.getOrderId());
                return responsePay;
            }
            throw new ApplicationRuntimeException("Behalf2AlipayOneGenerator", (Throwable)ex);
        }
    }

    @Deprecated
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("\u65b9\u6cd5\u5e9f\u5f03\uff0c\u8bf7\u52ff\u8c03\u7528");
    }
}

