/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.payunk.generator;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.MoneyUtils;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.payunk.BaseOrderGenerator;
import com.walker.pay.payunk.DefaultPayContext;
import com.walker.pay.payunk.Trans2AlipayResponsePay;
import com.walker.pay.payunk.util.AlipayUtils;
import com.walker.pay.payunk.util.SignUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class Trans2AlipayOneGenerator
extends BaseOrderGenerator {
    public Trans2AlipayOneGenerator(RestTemplate restTemplate) {
        this.setRestTemplate(restTemplate);
    }

    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        try {
            DefaultPayContext context = (DefaultPayContext)payContext;
            HashMap<String, Object> payMap = new HashMap<String, Object>(10);
            payMap.put("appid", context.getAppIdConfig().getStringValue());
            payMap.put("pay_type", "alipayReplace");
            payMap.put("user_account_id", context.getUserAccountId().getStringValue());
            payMap.put("amount", MoneyUtils.scaleYuan2Accuracy((long)platformOrder.getTotalMoney()));
            payMap.put("callback_url", platformOrder.getNotifyUrl());
            payMap.put("out_trade_no", String.valueOf(platformOrder.getId()));
            payMap.put("pay", JsonUtils.objectToJsonString((Object)AlipayUtils.acquireAlipayReplace(context)));
            payMap.put("extend", AlipayUtils.getAlipayInfo(platformOrder));
            String signStr = SignUtils.signature(payMap);
            payMap.put("sign", signStr);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity request = new HttpEntity(payMap, (MultiValueMap)headers);
            ResponseEntity entity = this.getRestTemplate().postForEntity("https://apipay.payunk.cn/pay/index/unifiedorder?format=jsonIn", (Object)request, String.class, new Object[0]);
            Trans2AlipayResponsePay responsePay = new Trans2AlipayResponsePay();
            String result = (String)entity.getBody();
            ObjectNode objectNode = JsonUtils.jsonStringToObjectNode((String)result);
            if (objectNode.get("code").intValue() != 200) {
                String error = objectNode.get("msg").toString();
                this.logger.error("\u652f\u4ed8\u5b9d\u4e2a\u4eba\u63d0\u73b0\u63a5\u53e3\u9519\u8bef\uff1a{}", (Object)error);
                responsePay.setStatus(false);
                responsePay.setMessage(error);
            } else {
                responsePay.setStatus(true);
                responsePay.setMessage("success");
                responsePay.setUrl(objectNode.get("url").toString());
                this.logger.error("\u652f\u4ed8\u5b9d\u4e2a\u4eba\u63d0\u73b0\u63a5\u53e3\u6210\u529f\uff1a{}", (Object)responsePay.getUrl());
            }
            return responsePay;
        }
        catch (Exception ex) {
            this.logger.error("\u8c03\u7528\u652f\u4ed8\u63a5\u53e3\u5f02\u5e38\uff0cTrans2AlipayOneGenerator\uff1a" + ex.getMessage(), (Throwable)ex);
            throw new ApplicationRuntimeException("Trans2AlipayOneGenerator", (Throwable)ex);
        }
    }

    @Deprecated
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("\u65b9\u6cd5\u5e9f\u5f03\uff0c\u8bf7\u52ff\u8c03\u7528");
    }
}

