/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.wechat.v2;

import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.wechat.v2.AppOrderResponsePay;
import com.walker.pay.wechat.v2.BaseOrderGenerator;
import com.walker.pay.wechat.v2.SignUtils;
import com.walker.pay.wechat.v2.WechatV2PayContext;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class AppOrderGenerator
extends BaseOrderGenerator {
    public AppOrderGenerator(RestTemplate restTemplate) {
        this.setRestTemplate(restTemplate);
    }

    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        WechatV2PayContext context = (WechatV2PayContext)payContext;
        String appId = context.getAppIdConfig().getStringValue();
        String mchId = context.getMchIdConfig().getStringValue();
        String apiKey = context.getApiKeyConfig().getStringValue();
        String request = this.toRequest(payContext.getProviderPayType(), platformOrder, appId, mchId, apiKey);
        ResponseEntity entity = this.getRestTemplate().postForEntity("https://api.mch.weixin.qq.com/pay/unifiedorder", (Object)request, String.class, new Object[0]);
        if (entity == null) {
            throw new RuntimeException("\u8c03\u7528'\u5fae\u4fe1APP'\u8ba2\u5355\u8fd4\u56de\u7a7a\u6570\u636e, orderId = " + platformOrder.getId());
        }
        Map<String, String> responseMap = SignUtils.decodeXml((String)entity.getBody());
        if (responseMap == null) {
            throw new RuntimeException("\u8c03\u7528'\u5fae\u4fe1APP'\u8ba2\u5355\u8fd4\u56de\u6570\u636e\u8f6c\u6362\u4e3a\u7a7a: SignUtils.decodeXml() == null");
        }
        AppOrderResponsePay responseValue = new AppOrderResponsePay();
        if (responseMap.get("return_code").equals("FAIL")) {
            responseValue.setStatus(false);
            responseValue.setMessage(responseMap.get("return_msg"));
            this.logger.debug("\u5fae\u4fe1APP\u652f\u4ed8\u8ba2\u5355\u8fd4\u56de\u5931\u8d25:{}", responseMap);
            return responseValue;
        }
        TreeMap<String, String> wxApiResult = new TreeMap<String, String>();
        wxApiResult.put("appId", appId);
        wxApiResult.put("partnerId", mchId);
        wxApiResult.put("prepayId", responseMap.get("prepay_id"));
        wxApiResult.put("packageValue", "Sign=WXPay");
        wxApiResult.put("nonceStr", StringUtils.generateRandomNumber((int)6));
        wxApiResult.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000L));
        LinkedList<KeyValue<String, String>> signParams = new LinkedList<KeyValue<String, String>>();
        signParams.add(new KeyValue((Object)"appid", (Object)appId));
        signParams.add(new KeyValue((Object)"noncestr", wxApiResult.get("nonceStr")));
        signParams.add(new KeyValue((Object)"package", wxApiResult.get("packageValue")));
        signParams.add(new KeyValue((Object)"partnerid", (Object)mchId));
        signParams.add(new KeyValue((Object)"prepayid", wxApiResult.get("prepayId")));
        signParams.add(new KeyValue((Object)"timestamp", wxApiResult.get("timeStamp")));
        wxApiResult.put("sign", SignUtils.getAppSign(signParams, apiKey));
        responseValue.setAppOrderInfo(wxApiResult);
        return responseValue;
    }

    @Deprecated
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("\u8be5\u65b9\u6cd5\u5df2\u5e9f\u5f03!");
    }
}

