/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.wechat.v2;

import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.AbstractOrderGenerator;
import com.walker.pay.Order;
import com.walker.pay.ResponsePay;
import com.walker.pay.wechat.v2.H5ResponsePay;
import com.walker.pay.wechat.v2.SignUtils;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public abstract class BaseOrderGenerator
extends AbstractOrderGenerator {
    private RestTemplate restTemplate;

    protected ResponsePay remoteRequest(String request, Order platformOrder) {
        ResponseEntity entity = this.getRestTemplate().postForEntity("https://api.mch.weixin.qq.com/pay/unifiedorder", (Object)request, String.class, new Object[0]);
        if (entity == null) {
            throw new RuntimeException("\u8c03\u7528'\u5fae\u4fe1H5'\u8ba2\u5355\u8fd4\u56de\u7a7a\u6570\u636e, orderId = " + platformOrder.getId());
        }
        Map<String, String> responseMap = SignUtils.decodeXml((String)entity.getBody());
        if (responseMap == null) {
            throw new RuntimeException("\u8c03\u7528'\u5fae\u4fe1H5'\u8ba2\u5355\u8fd4\u56de\u6570\u636e\u8f6c\u6362\u4e3a\u7a7a: SignUtils.decodeXml() == null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(responseMap.toString());
        }
        H5ResponsePay responsePay = new H5ResponsePay();
        if (responseMap.get("return_code").equals("FAIL")) {
            responsePay.setStatus(false);
            responsePay.setMessage(responseMap.get("return_msg"));
        } else if (responseMap.get("result_code").equals("FAIL")) {
            responsePay.setStatus(false);
            responsePay.setMessage(responseMap.get("err_code_des"));
            this.logger.error("\u5fae\u4fe1\u751f\u6210\u9884\u8ba2\u5355\u8c03\u7528\u6210\u529f\uff0c\u4f46\u8fd4\u56de\u9519\u8bef\u7ed3\u679c:" + responseMap.get("err_code"));
        } else {
            responsePay.setCodeUrl(responseMap.get("code_url"));
            responsePay.setPrepayId(responseMap.get("prepay_id"));
            responsePay.setTradeType(responseMap.get("trade_type"));
            responsePay.setAppId(responseMap.get("appid"));
            responsePay.setMchId(responseMap.get("mch_id"));
            if (StringUtils.isNotEmpty((String)responseMap.get("sub_appid"))) {
                responsePay.setSubAppId(responseMap.get("sub_appid"));
                responsePay.setSubMchId(responseMap.get("sub_mch_id"));
            }
        }
        return responsePay;
    }

    protected String toRequest(String providerPayType, Order platformOrder, String appId, String mchId, String apiKey) {
        LinkedList<KeyValue<String, String>> packageParams = new LinkedList<KeyValue<String, String>>();
        packageParams.add(new KeyValue((Object)"appid", (Object)appId));
        packageParams.add(new KeyValue((Object)"body", (Object)platformOrder.getTitle()));
        packageParams.add(new KeyValue((Object)"detail", (Object)platformOrder.getAttach()));
        packageParams.add(new KeyValue((Object)"mch_id", (Object)mchId));
        packageParams.add(new KeyValue((Object)"nonce_str", (Object)StringUtils.generateRandomNumber((int)6)));
        packageParams.add(new KeyValue((Object)"notify_url", (Object)platformOrder.getNotifyUrl()));
        if (StringUtils.isNotEmpty((String)platformOrder.getBuyerId())) {
            packageParams.add(new KeyValue((Object)"openid", (Object)platformOrder.getBuyerId()));
        }
        packageParams.add(new KeyValue((Object)"out_trade_no", (Object)String.valueOf(platformOrder.getId())));
        packageParams.add(new KeyValue((Object)"spbill_create_ip", (Object)platformOrder.getIp()));
        packageParams.add(new KeyValue((Object)"total_fee", (Object)String.valueOf(platformOrder.getTotalMoney())));
        packageParams.add(new KeyValue((Object)"trade_type", (Object)providerPayType));
        String sign = SignUtils.getPackageSign(packageParams, apiKey);
        packageParams.add((KeyValue<String, String>)new KeyValue((Object)"sign", (Object)sign));
        return SignUtils.toXml(packageParams);
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

