/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.wechat.v2;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.response.ScanOrderResponsePay;
import com.walker.pay.wechat.v2.BaseOrderGenerator;
import com.walker.pay.wechat.v2.SignUtils;
import com.walker.pay.wechat.v2.WechatV2PayContext;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class ScanOrderGenerator
extends BaseOrderGenerator {
    public ScanOrderGenerator(RestTemplate restTemplate) {
        this.setRestTemplate(restTemplate);
    }

    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        WechatV2PayContext context = (WechatV2PayContext)payContext;
        String request = this.toRequest(payContext.getProviderPayType(), platformOrder, context.getAppIdConfig().getStringValue(), context.getMchIdConfig().getStringValue(), context.getApiKeyConfig().getStringValue());
        ResponseEntity entity = this.getRestTemplate().postForEntity("https://api.mch.weixin.qq.com/pay/unifiedorder", (Object)request, String.class, new Object[0]);
        if (entity == null) {
            throw new RuntimeException("\u8c03\u7528'\u5fae\u4fe1\u626b\u7801'\u8ba2\u5355\u8fd4\u56de\u7a7a\u6570\u636e, orderId = " + platformOrder.getId());
        }
        Map<String, String> responseMap = SignUtils.decodeXml((String)entity.getBody());
        if (responseMap == null) {
            throw new RuntimeException("\u8c03\u7528'\u5fae\u4fe1\u626b\u7801'\u8ba2\u5355\u8fd4\u56de\u6570\u636e\u8f6c\u6362\u4e3a\u7a7a: SignUtils.decodeXml() == null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(responseMap.toString());
        }
        ScanOrderResponsePay responseValue = new ScanOrderResponsePay();
        if (responseMap.get("return_code").equals("FAIL")) {
            responseValue.setStatus(false);
            responseValue.setMessage(responseMap.get("return_msg"));
        } else {
            responseValue.setCodeUrl(responseMap.get("code_url"));
        }
        return responseValue;
    }

    @Deprecated
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("\u8be5\u65b9\u6cd5\u5df2\u5e9f\u5f03!");
    }
}

