/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.wechat.v2;

import com.walker.infrastructure.core.domx.JaxbDomParser;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.MD5;
import com.walker.infrastructure.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SignUtils {
    protected static final Logger logger = LoggerFactory.getLogger(SignUtils.class);
    private static final JaxbDomParser domParser = new JaxbDomParser();

    public static String toXmlNotifyStatus(String status, String msg) {
        ArrayList<KeyValue<String, String>> params = new ArrayList<KeyValue<String, String>>(2);
        params.add(new KeyValue((Object)"return_code", (Object)status));
        params.add(new KeyValue((Object)"return_msg", (Object)msg));
        return SignUtils.toXml(params);
    }

    public static Map<String, String> decodeXml(String content) {
        HashMap<String, String> xml = new HashMap<String, String>();
        Document doc = domParser.getDocumentFromXml(content);
        Node node = doc.getFirstChild();
        for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            xml.put(childNode.getNodeName(), childNode.getTextContent());
        }
        return xml;
    }

    public static String toXml(List<KeyValue<String, String>> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("<xml>");
        for (int i = 0; i < params.size(); ++i) {
            sb.append("<" + (String)params.get(i).getKey() + ">");
            sb.append((String)params.get(i).getValue());
            sb.append("</" + (String)params.get(i).getKey() + ">");
        }
        sb.append("</xml>");
        return sb.toString();
    }

    public static final String getAppSign(List<KeyValue<String, String>> params, String wxApiKey) {
        return SignUtils.getSign(params, wxApiKey, false);
    }

    public static final String getPackageSign(List<KeyValue<String, String>> params, String wxApiKey) {
        return SignUtils.getSign(params, wxApiKey, true);
    }

    public static final String getSign(List<KeyValue<String, String>> params, String wxApiKey, boolean upperCase) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.size(); ++i) {
            sb.append((String)params.get(i).getKey());
            sb.append("=");
            sb.append((String)params.get(i).getValue());
            sb.append("&");
        }
        sb.append("key=");
        sb.append(wxApiKey);
        logger.debug("sign = {}", (Object)sb);
        try {
            String packageSign = upperCase ? MD5.getMessageDigest((byte[])sb.toString().getBytes("UTF-8")).toUpperCase() : MD5.getMessageDigest((byte[])sb.toString().getBytes("UTF-8"));
            return packageSign;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("\u7b7e\u540d\u4e0d\u652f\u6301\u7684\u5b57\u7b26\u96c6utf8");
        }
    }

    public static String getSign(Map<String, String> map, String signKey) throws Exception {
        Set<String> keySet = map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (((String)k).equals("sign") || !StringUtils.isNotEmpty((String)map.get(k)) || map.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(map.get(k).trim()).append("&");
        }
        sb.append("key=").append(signKey);
        String sign = MD5.getMessageDigest((byte[])sb.toString().getBytes("UTF-8")).toUpperCase();
        return sign;
    }
}

