/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.wechat.v2;

import com.walker.pay.CallBackException;
import com.walker.pay.NotifyValue;
import com.walker.pay.Order;
import com.walker.pay.PayType;
import com.walker.pay.ResponsePay;
import com.walker.pay.callback.AbstractOrderCallback;
import com.walker.pay.response.ScanOrderResponsePay;
import com.walker.pay.wechat.v2.AppOrderResponsePay;
import com.walker.pay.wechat.v2.H5ResponsePay;
import com.walker.pay.wechat.v2.NotifyOrder;

public class WechatV2OrderCallback
extends AbstractOrderCallback {
    public void onOrderPrepare(Order platformOrder, ResponsePay responsePay) {
        if (platformOrder.getPayType() == PayType.App) {
            this.doPrepareOrder(platformOrder, (AppOrderResponsePay)responsePay);
        } else if (platformOrder.getPayType() == PayType.Scan) {
            this.doPrepareOrder(platformOrder, (ScanOrderResponsePay)responsePay);
        } else if (platformOrder.getPayType() == PayType.H5) {
            this.doPrepareOrder(platformOrder, (H5ResponsePay)responsePay);
        } else if (platformOrder.getPayType() == PayType.Applet) {
            this.doPrepareOrder(platformOrder, (H5ResponsePay)responsePay);
        } else {
            throw new UnsupportedOperationException("\u672a\u5b9e\u73b0\u65b9\u6cd5: onOrderPrepare(" + platformOrder.getPayType() + ")");
        }
    }

    public void onOrderNotify(NotifyValue<?> notifyValue) throws CallBackException {
        if (!(notifyValue.getData() instanceof NotifyOrder)) {
            throw new IllegalArgumentException("notifyValue.getData()\u5fc5\u987b\u662f NotifyOrder \u5bf9\u8c61!");
        }
        this.doNotifyOrderPay(notifyValue);
    }

    protected void doPrepareOrder(Order platformOrder, AppOrderResponsePay responsePay) {
        this.logger.info("\u9ed8\u8ba4\u5b9e\u73b0: \u6267\u884c\u4fdd\u5b58'AppOrderResponsePay'\u8ba2\u5355\u64cd\u4f5c\uff0corder={}", (Object)platformOrder);
    }

    protected void doPrepareOrder(Order platformOrder, ScanOrderResponsePay responsePay) {
        this.logger.info("\u9ed8\u8ba4\u5b9e\u73b0: \u6267\u884c\u4fdd\u5b58'ScanOrderResponsePay'\u8ba2\u5355\u64cd\u4f5c\uff0corder={}", (Object)platformOrder);
    }

    protected void doPrepareOrder(Order platformOrder, H5ResponsePay responsePay) {
        this.logger.info("\u9ed8\u8ba4\u5b9e\u73b0: \u6267\u884c\u4fdd\u5b58'H5ResponsePay'\u8ba2\u5355\u64cd\u4f5c\uff0corder={}", (Object)platformOrder);
    }

    protected void doNotifyOrderPay(NotifyValue<NotifyOrder> notifyValue) {
        this.logger.info("\u9ed8\u8ba4\u5b9e\u73b0: \u63a5\u6536\u652f\u4ed8\u901a\u77e5\uff0cnotifyValue={}", notifyValue);
    }
}

