package com.walker.pay.wechat;

public class Constants {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    //~ 定义第三方如微信等的支付方式，这个需要与系统支付方式做对应。
    //~ 2023-01-16
    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    public static final String PAY_TYPE_NATIVE = "NATIVE";
    public static final String PAY_TYPE_APP = "APP";
    public static final String PAY_TYPE_H5 = "JSAPI";

    /** 该定义与微信支付类型没关系，仅仅是能找到订单生成器而已。2023-09-15 */
    public static final String PAY_TYPE_ROUTINE = "ROUTINE";

    public static final String URL_ORDER_V2 = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    public static final String URL_SEARCH_V2 = "https://api.mch.weixin.qq.com/pay/orderquery";

    /** 常量定义：微信商户号（公众号） */
    public static final String CONFIG_KEY_MCH_ID = "PAY.WX.MCH_ID";
    /** 常量定义：微信商户号（小程序） */
    public static final String CONFIG_KEY_MCH_ID_ROUTINE = "pay_routine_mchid";
    /** 常量定义：微信公众号应用ID */
    public static final String CONFIG_KEY_APP_ID = "PAY.WX.APPID";
    /** 常量定义：微信小程序应用ID */
    public static final String CONFIG_KEY_APP_ID_ROUTINE = "routine_appid";
    /** 常量定义：微信公众要签名密钥 */
    public static final String CONFIG_KEY_API_KEY = "PAY.WX.API_KEY";
    /** 常量定义：微信小程序支付密钥（商户端配置） */
    public static final String CONFIG_KEY_API_KEY_ROUTINE = "pay_routine_key";

    public static final String CODE_SUCCESS = "SUCCESS";
    public static final String CODE_OK = "OK";
    public static final String CODE_FAIL = "FAIL";

    /** 微信支付查询状态：支付成功*/
    public static final String TRADE_STATE_SUCCESS = "SUCCESS";
    /** 微信支付查询状态：转入退款*/
    public static final String TRADE_STATE_REFUND = "REFUND";
    /** 微信支付查询状态：未支付*/
    public static final String TRADE_STATE_NOTPAY = "NOTPAY";
    /** 微信支付查询状态：已关闭*/
    public static final String TRADE_STATE_CLOSED = "CLOSED";
    /** 微信支付查询状态：已撤销(刷卡支付)*/
    public static final String TRADE_STATE_REVOKED = "REVOKED";
    /** 微信支付查询状态：用户支付中*/
    public static final String TRADE_STATE_USERPAYING = "USERPAYING";
    /** 微信支付查询状态：支付失败*/
    public static final String TRADE_STATE_PAYERROR = "PAYERROR";
}
