package com.walker.pay.wechat.v2;

import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.wechat.Constants;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class AppOrderGenerator extends BaseOrderGenerator {

    public AppOrderGenerator(RestTemplate restTemplate){
        this.setRestTemplate(restTemplate);
    }

    @Override
    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        WechatV2PayContext context = (WechatV2PayContext) payContext;
        String appId = context.getAppIdConfig().getStringValue();
        String mchId = context.getMchIdConfig().getStringValue();
        String apiKey = context.getApiKeyConfig().getStringValue();

        String request = this.toRequest(payContext.getProviderPayType(), platformOrder, appId, mchId, apiKey);

        ResponseEntity<String> entity = this.getRestTemplate().postForEntity(Constants.URL_ORDER_V2, request, String.class);
        if(entity == null){
            throw new RuntimeException("调用'微信APP'订单返回空数据, orderId = " + platformOrder.getId());
        }
        Map<String, String> responseMap = SignUtils.decodeXml(entity.getBody());
        if(responseMap == null){
            throw new RuntimeException("调用'微信APP'订单返回数据转换为空: SignUtils.decodeXml() == null");
        }

        AppOrderResponsePay responseValue = new AppOrderResponsePay();

        if(responseMap.get("return_code").equals("FAIL")){
//            logger.error("调用微信统一下单远程接口失败：" + responseMap.get("return_msg"));
            responseValue.setStatus(false);
            responseValue.setMessage(responseMap.get("return_msg"));
            logger.debug("微信APP支付订单返回失败:{}", responseMap);
            return responseValue;
        }

        // 需要组装手机APP需要的数据，用于调起微信APP完成App支付
        TreeMap<String, String> wxApiResult = new TreeMap<>();
        wxApiResult.put("appId", appId);
        wxApiResult.put("partnerId", mchId);
        wxApiResult.put("prepayId", responseMap.get("prepay_id"));
        wxApiResult.put("packageValue", "Sign=WXPay");
        wxApiResult.put("nonceStr", StringUtils.generateRandomNumber(6));
        wxApiResult.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000));

        List<KeyValue<String, String>> signParams = new LinkedList<>();
        signParams.add(new KeyValue("appid", appId));
        signParams.add(new KeyValue("noncestr", wxApiResult.get("nonceStr")));
        signParams.add(new KeyValue("package", wxApiResult.get("packageValue")));
        signParams.add(new KeyValue("partnerid", mchId));
        signParams.add(new KeyValue("prepayid", wxApiResult.get("prepayId")));
        signParams.add(new KeyValue("timestamp", wxApiResult.get("timeStamp")));
        wxApiResult.put("sign", SignUtils.getAppSign(signParams, apiKey));

        responseValue.setAppOrderInfo(wxApiResult);
        return responseValue;
    }

    @Deprecated
    @Override
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
//        String appId = configuration.get(Constants.CONFIG_KEY_APP_ID).getStringValue();
//        String mchId = configuration.get(Constants.CONFIG_KEY_MCH_ID).getStringValue();
//        String apiKey = configuration.get(Constants.CONFIG_KEY_API_KEY).getStringValue();
        throw new UnsupportedOperationException("该方法已废弃!");
        /*String request = this.toRequest(providerPayType, platformOrder, appId, mchId, apiKey);

        ResponseEntity<String> entity = restTemplate.postForEntity(Constants.URL_ORDER_V2, request, String.class);
        if(entity == null){
            throw new RuntimeException("调用'微信APP'订单返回空数据, orderId = " + platformOrder.getId());
        }
        Map<String, String> responseMap = SignUtils.decodeXml(entity.getBody());
        if(responseMap == null){
            throw new RuntimeException("调用'微信APP'订单返回数据转换为空: SignUtils.decodeXml() == null");
        }

        AppOrderResponsePay responseValue = new AppOrderResponsePay();

        if(responseMap.get("return_code").equals("FAIL")){
//            logger.error("调用微信统一下单远程接口失败：" + responseMap.get("return_msg"));
            responseValue.setStatus(false);
            responseValue.setMessage(responseMap.get("return_msg"));
            logger.debug("微信APP支付订单返回失败:{}", responseMap);
            return responseValue;
        }

        // 需要组装手机APP需要的数据，用于调起微信APP完成App支付
        TreeMap<String, String> wxApiResult = new TreeMap<>();
        wxApiResult.put("appId", appId);
        wxApiResult.put("partnerId", mchId);
        wxApiResult.put("prepayId", responseMap.get("prepay_id"));
        wxApiResult.put("packageValue", "Sign=WXPay");
        wxApiResult.put("nonceStr", StringUtils.generateRandomNumber(6));
        wxApiResult.put("timeStamp", String.valueOf(System.currentTimeMillis() / 1000));

        List<KeyValue<String, String>> signParams = new LinkedList<>();
        signParams.add(new KeyValue("appid", appId));
        signParams.add(new KeyValue("noncestr", wxApiResult.get("nonceStr")));
        signParams.add(new KeyValue("package", wxApiResult.get("packageValue")));
        signParams.add(new KeyValue("partnerid", mchId));
        signParams.add(new KeyValue("prepayid", wxApiResult.get("prepayId")));
        signParams.add(new KeyValue("timestamp", wxApiResult.get("timeStamp")));
        wxApiResult.put("sign", SignUtils.getAppSign(signParams, apiKey));

        responseValue.setAppOrderInfo(wxApiResult);
        return responseValue;*/
    }

//    private RestTemplate restTemplate;

//    @Override
//    protected String acquireSign(List<KeyValue<String, String>> params, String apiKey) {
//        return SignUtils.getAppSign(params, apiKey);
//    }
}
