package com.walker.pay.wechat.v2;

import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.AbstractOrderGenerator;
import com.walker.pay.Order;
import com.walker.pay.ResponsePay;
import com.walker.pay.wechat.Constants;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class BaseOrderGenerator extends AbstractOrderGenerator {

    protected ResponsePay remoteRequest(String request, Order platformOrder){
        ResponseEntity<String> entity = this.getRestTemplate().postForEntity(Constants.URL_ORDER_V2, request, String.class);
        if(entity == null){
            throw new RuntimeException("调用'微信H5'订单返回空数据, orderId = " + platformOrder.getId());
        }
        Map<String, String> responseMap = SignUtils.decodeXml(entity.getBody());
        if(responseMap == null){
            throw new RuntimeException("调用'微信H5'订单返回数据转换为空: SignUtils.decodeXml() == null");
        }
        if(logger.isDebugEnabled()){
            logger.debug(responseMap.toString());
        }

        H5ResponsePay responsePay = new H5ResponsePay();
        if(responseMap.get("return_code").equals("FAIL")){
            responsePay.setStatus(false);
            responsePay.setMessage(responseMap.get("return_msg"));
        } else if(responseMap.get("result_code").equals("FAIL")){
            responsePay.setStatus(false);
            responsePay.setMessage(responseMap.get("err_code_des"));
            logger.error("微信生成预订单调用成功，但返回错误结果:" + responseMap.get("err_code"));
        } else {
            responsePay.setCodeUrl(responseMap.get("code_url"));
            responsePay.setPrepayId(responseMap.get("prepay_id"));
            responsePay.setTradeType(responseMap.get("trade_type"));
            responsePay.setAppId(responseMap.get("appid"));
            responsePay.setMchId(responseMap.get("mch_id"));
            if(StringUtils.isNotEmpty(responseMap.get("sub_appid"))){
                responsePay.setSubAppId(responseMap.get("sub_appid"));
                responsePay.setSubMchId(responseMap.get("sub_mch_id"));
            }
        }
        return responsePay;
    }

    protected String toRequest(String providerPayType, Order platformOrder, String appId, String mchId, String apiKey){
        List<KeyValue<String, String>> packageParams = new LinkedList<>();
        //appid 应用ID
        packageParams.add(new KeyValue<>("appid", appId));
        //商品描述，显示在app支付界面中标题
        packageParams.add(new KeyValue("body", platformOrder.getTitle()));
        //该属性，可以传递业务自己的自定义参数
        packageParams.add(new KeyValue("detail", platformOrder.getAttach()));
        //商户号 	mch_id
        packageParams.add(new KeyValue("mch_id", mchId));
        //随机字符串 	nonce_str
        packageParams.add(new KeyValue("nonce_str", StringUtils.generateRandomNumber(6)));

        packageParams.add(new KeyValue("notify_url", platformOrder.getNotifyUrl()));

        // 2023-08-28 对于H5公众号支付，需要传入用户信息，这里是用户openId
        // 必须放在这里，因为签名需要顺序!
        if(StringUtils.isNotEmpty(platformOrder.getBuyerId())){
            packageParams.add(new KeyValue("openid", platformOrder.getBuyerId()));
        }

        //商户订单号
        packageParams.add(new KeyValue("out_trade_no", String.valueOf(platformOrder.getId())));
        //ip
        packageParams.add(new KeyValue("spbill_create_ip", platformOrder.getIp()));
        //总价格 分单位
        packageParams.add(new KeyValue("total_fee",String.valueOf(platformOrder.getTotalMoney())));
        // 支付类型
        packageParams.add(new KeyValue("trade_type", providerPayType));

//        签名 	sign
        String sign = SignUtils.getPackageSign(packageParams, apiKey);
        packageParams.add(new KeyValue<>("sign", sign));
//        packageParams.add(new KeyValue<>("sign", this.acquireSign(packageParams, apiKey)));
        return SignUtils.toXml(packageParams);
    }

//    /**
//     * 获得签名，每种支付方式可能会略有不同。<p></p>
//     * V2版本发现，native与app 仅仅大小写不同。
//     * @param params
//     * @param apiKey
//     * @return
//     * @date 2023-01-16
//     */
//    protected abstract String acquireSign(List<KeyValue<String, String>> params, String apiKey);

    public RestTemplate getRestTemplate() {
        return restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private RestTemplate restTemplate;
}
