package com.walker.pay.wechat.v2;

import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.wechat.Constants;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * 微信H5公众号支付预订单生成器实现。
 * @author 时克英
 * @date 2023-06-11
 */
public class H5OrderGenerator extends BaseOrderGenerator{

    public H5OrderGenerator(RestTemplate restTemplate){
        this.setRestTemplate(restTemplate);
    }

    @Override
    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        WechatV2PayContext context = (WechatV2PayContext)payContext;
        String request = this.toRequest(payContext.getProviderPayType(), platformOrder
                , context.getAppIdConfig().getStringValue(), context.getMchIdConfig().getStringValue(), context.getApiKeyConfig().getStringValue());
        logger.debug("apiKey = {}", context.getApiKeyConfig().getStringValue());

//        ResponseEntity<String> entity = this.getRestTemplate().postForEntity(Constants.URL_ORDER_V2, request, String.class);
//        if(entity == null){
//            throw new RuntimeException("调用'微信H5'订单返回空数据, orderId = " + platformOrder.getId());
//        }
//        Map<String, String> responseMap = SignUtils.decodeXml(entity.getBody());
//        if(responseMap == null){
//            throw new RuntimeException("调用'微信H5'订单返回数据转换为空: SignUtils.decodeXml() == null");
//        }
//        if(logger.isDebugEnabled()){
//            logger.debug(responseMap.toString());
//        }
//
//        H5ResponsePay responsePay = new H5ResponsePay();
//        if(responseMap.get("return_code").equals("FAIL")){
//            responsePay.setStatus(false);
//            responsePay.setMessage(responseMap.get("return_msg"));
//        } else if(responseMap.get("result_code").equals("FAIL")){
//            responsePay.setStatus(false);
//            responsePay.setMessage(responseMap.get("err_code_des"));
//            logger.error("微信生成预订单调用成功，但返回错误结果:" + responseMap.get("err_code"));
//        } else {
//            responsePay.setCodeUrl(responseMap.get("code_url"));
//            responsePay.setPrepayId(responseMap.get("prepay_id"));
//            responsePay.setTradeType(responseMap.get("trade_type"));
//            responsePay.setAppId(responseMap.get("appid"));
//            responsePay.setMchId(responseMap.get("mch_id"));
//            if(StringUtils.isNotEmpty(responseMap.get("sub_appid"))){
//                responsePay.setSubAppId(responseMap.get("sub_appid"));
//                responsePay.setSubMchId(responseMap.get("sub_mch_id"));
//            }
//        }
//        return responsePay;
        return this.remoteRequest(request, platformOrder);
    }

    @Deprecated
    @Override
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("方法废弃，请勿调用");
    }
}
