package com.walker.pay.wechat.v2;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Convertor;
import com.walker.pay.NotifyValue;
import com.walker.pay.PayChannel;
import com.walker.pay.wechat.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;

public class NotifyOrderConvertor
//        extends AbstractJsonConvertor<NotifyValue<NotifyOrder>>
        implements Convertor<NotifyValue<NotifyOrder>> {

    protected final transient Logger logger = LoggerFactory.getLogger(getClass());

    @Override
    public NotifyValue<NotifyOrder> toGenericObject(Object data) {
        Map<String, String> paramMap = SignUtils.decodeXml(data.toString());
        String return_code = paramMap.get("return_code");
        if (StringUtils.isEmpty(return_code)) {
            throw new IllegalArgumentException("[wxPayNotify]调用参数错误：return_code不存在");
        }

        NotifyValue<NotifyOrder> notifyValue = new NotifyValue<>();

        String resultCode = paramMap.get("result_code");
        if(return_code.equals(Constants.CODE_SUCCESS) && resultCode != null && resultCode.equals(Constants.CODE_SUCCESS)){
            logger.debug("...........接收到微信通知：" + paramMap);
            notifyValue.setStatus(true);
            notifyValue.setSource(data);
            notifyValue.setOrderId(paramMap.get("out_trade_no"));
            notifyValue.setCreateTime(paramMap.get("time_end"));
            notifyValue.setTradeNo(paramMap.get("transaction_id"));
            notifyValue.setBuyerId(paramMap.get("openid"));
            notifyValue.setDataType("test");
            // 通知id就是微信订单ID，暂时这样。
            notifyValue.setId(notifyValue.getTradeNo());
            notifyValue.setPayChannel(PayChannel.WechatPay);

            // 支付类型，2023-08-30
            if(paramMap.containsKey("trade_type")){
                String tradeType = paramMap.get("trade_type");
//                if(tradeType.equals(Constants.PAY_TYPE_H5)){
//                    notifyValue.setPayChannel(PayC);
//                }
                notifyValue.setTradeType(tradeType);
            }

            NotifyOrder notifyOrder = new NotifyOrder();
            notifyOrder.setTotalMoney(Long.parseLong(paramMap.get("total_fee")));
            notifyOrder.setOpenId(notifyValue.getBuyerId());
            notifyOrder.setDeviceInfo(paramMap.get("device_info"));
            notifyOrder.setAttach(paramMap.get("attach"));

            notifyValue.setData(notifyOrder);
        }
        return notifyValue;
    }

//    @Override
//    protected NotifyValue<NotifyOrder> transferTo(ObjectNode objectNode) {
//        return null;
//    }
}
