package com.walker.pay.wechat.v2;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.wechat.Constants;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * 微信小程序，订单生成器。
 * <pre>
 *     1)其实和公众号H5支付一样，但因为appId、appKey等参数不同，所以这里添加新的对应。
 * </pre>
 * @author 时克英
 * @date 2023-09-15
 */
public class RoutineOrderGenerator extends BaseOrderGenerator{

    public RoutineOrderGenerator(RestTemplate restTemplate){
        this.setRestTemplate(restTemplate);
    }

    @Override
    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        // 注意：这里 getProviderPayType 必须固定值，因为它同H5一样，但传过来的值是：ROUTINE，微信支付类型中并未定义！
        WechatV2PayContext context = (WechatV2PayContext)payContext;
//        String request = this.toRequest(payContext.getProviderPayType()
        String request = this.toRequest(Constants.PAY_TYPE_H5
                , platformOrder, context.getRoutineAppId().getStringValue(), context.getRoutineMchId().getStringValue()
                , context.getRoutineSecret().getStringValue());
        logger.debug("apiKey = {}", context.getRoutineSecret().getStringValue());
        return this.remoteRequest(request, platformOrder);
    }

    @Deprecated
    @Override
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        throw new UnsupportedOperationException("方法废弃，请勿调用");
    }
}
