package com.walker.pay.wechat.v2;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.Order;
import com.walker.pay.PayContext;
import com.walker.pay.ResponsePay;
import com.walker.pay.response.ScanOrderResponsePay;
import com.walker.pay.wechat.Constants;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.util.Map;

/**
 * 微信支付，V2版本的扫码订单生成器。<p></p>
 * 会返回商品连接的二维码，用户通过微信APP扫码即可完成付款。
 * @author 时克英
 * @date 2023-01-16
 */
public class ScanOrderGenerator extends BaseOrderGenerator {

    public ScanOrderGenerator(RestTemplate restTemplate){
        this.setRestTemplate(restTemplate);
    }

    @Override
    protected ResponsePay invoke(PayContext payContext, Order platformOrder) {
        WechatV2PayContext context = (WechatV2PayContext)payContext;
        String request = this.toRequest(payContext.getProviderPayType(), platformOrder
                , context.getAppIdConfig().getStringValue(), context.getMchIdConfig().getStringValue(), context.getApiKeyConfig().getStringValue());

        ResponseEntity<String> entity = this.getRestTemplate().postForEntity(Constants.URL_ORDER_V2, request, String.class);
        if(entity == null){
            throw new RuntimeException("调用'微信扫码'订单返回空数据, orderId = " + platformOrder.getId());
        }
        Map<String, String> responseMap = SignUtils.decodeXml(entity.getBody());
        if(responseMap == null){
            throw new RuntimeException("调用'微信扫码'订单返回数据转换为空: SignUtils.decodeXml() == null");
        }
        if(logger.isDebugEnabled()){
            logger.debug(responseMap.toString());
        }

        ScanOrderResponsePay responseValue = new ScanOrderResponsePay();
        if(responseMap.get("return_code").equals("FAIL")){
//            logger.error("调用微信统一下单远程接口失败：" + responseMap.get("return_msg"));
            responseValue.setStatus(false);
            responseValue.setMessage(responseMap.get("return_msg"));
        } else {
            responseValue.setCodeUrl(responseMap.get("code_url"));
        }
        return responseValue;
    }

    @Deprecated
    @Override
    protected ResponsePay invoke(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
//        HttpHeaders headers = new HttpHeaders();
//        headers.setContentType(MediaType.parseMediaType("application/json; charset=UTF-8"));
        throw new UnsupportedOperationException("该方法已废弃!");
        /*String request = this.toRequest(providerPayType, platformOrder
                , configuration.get(Constants.CONFIG_KEY_APP_ID).getStringValue()
                , configuration.get(Constants.CONFIG_KEY_MCH_ID).getStringValue()
                , configuration.get(Constants.CONFIG_KEY_API_KEY).getStringValue());
        ResponseEntity<String> entity = restTemplate.postForEntity(Constants.URL_ORDER_V2, request, String.class);
        if(entity == null){
            throw new RuntimeException("调用'微信扫码'订单返回空数据, orderId = " + platformOrder.getId());
        }
        Map<String, String> responseMap = SignUtils.decodeXml(entity.getBody());
        if(responseMap == null){
            throw new RuntimeException("调用'微信扫码'订单返回数据转换为空: SignUtils.decodeXml() == null");
        }
        if(logger.isDebugEnabled()){
            logger.debug(responseMap.toString());
        }

        ScanOrderResponsePay responseValue = new ScanOrderResponsePay();
        if(responseMap.get("return_code").equals("FAIL")){
            responseValue.setStatus(false);
            responseValue.setMessage(responseMap.get("return_msg"));
        } else {
            responseValue.setCodeUrl(responseMap.get("code_url"));
        }
        return responseValue;*/
    }

//    private String toRequest(Order platformOrder, String appId, String mchId, String apiKey){
//        List<KeyValue<String, String>> packageParams = new LinkedList<>();
//        //appid 应用ID
//        packageParams.add(new KeyValue<>("appid", appId));
//        //商品描述，显示在app支付界面中标题
//        packageParams.add(new KeyValue("body", platformOrder.getTitle()));
//        //该属性，可以传递业务自己的自定义参数
//        packageParams.add(new KeyValue("detail", platformOrder.getAttach()));
//        //商户号 	mch_id
//        packageParams.add(new KeyValue("mch_id", mchId));
//        //随机字符串 	nonce_str
//        packageParams.add(new KeyValue("nonce_str", StringUtils.generateRandomNumber(6)));
//
//        packageParams.add(new KeyValue("notify_url", platformOrder.getNotifyUrl()));
//        //商户订单号
//        packageParams.add(new KeyValue("out_trade_no", String.valueOf(platformOrder.getId())));
//        //ip
//        packageParams.add(new KeyValue("spbill_create_ip", platformOrder.getIp()));
//        //总价格 分单位
//        packageParams.add(new KeyValue("total_fee",String.valueOf(platformOrder.getTotalMoney())));
//        // 支付类型
//        packageParams.add(new KeyValue("trade_type", "NATIVE"));
//
//        String sign = SignUtils.getSign(packageParams, apiKey);
//        //签名 	sign
//        packageParams.add(new KeyValue<>("sign", sign));
//        return SignUtils.toXml(packageParams);
//    }

//    public void setRestTemplate(RestTemplate restTemplate) {
//        this.restTemplate = restTemplate;
//    }
//    private RestTemplate restTemplate;

}
