package com.walker.pay.wechat.v2;

import com.walker.pay.CallBackException;
import com.walker.pay.NotifyValue;
import com.walker.pay.Order;
import com.walker.pay.PayType;
import com.walker.pay.ResponsePay;
import com.walker.pay.callback.AbstractOrderCallback;
import com.walker.pay.response.ScanOrderResponsePay;

/**
 * 微信V2版本，默认订单回调实现。<p></p>
 * 该对象应当在平台侧被重写，以实现对订单的业务操作，如:
 * <pre>
 *     1.保存 预下单信息
 *     2.接收 支付通知
 *     3.等等
 * </pre>
 * @author 时克英
 * @date 2023-02-20
 */
public class WechatV2OrderCallback extends AbstractOrderCallback {

    @Override
    public void onOrderPrepare(Order platformOrder, ResponsePay responsePay) {
        if(platformOrder.getPayType() == PayType.App){
            this.doPrepareOrder(platformOrder, (AppOrderResponsePay) responsePay);
        } else if(platformOrder.getPayType() == PayType.Scan){
            this.doPrepareOrder(platformOrder, (ScanOrderResponsePay) responsePay);
        } else if(platformOrder.getPayType() == PayType.H5){
            this.doPrepareOrder(platformOrder, (H5ResponsePay)responsePay);
        } else if(platformOrder.getPayType() == PayType.Applet) {
            // 小程序类，2023-09-15
            this.doPrepareOrder(platformOrder, (H5ResponsePay)responsePay);
        } else {
            throw new UnsupportedOperationException("未实现方法: onOrderPrepare(" + platformOrder.getPayType() + ")");
        }
    }

    @Override
    public void onOrderNotify(NotifyValue<?> notifyValue) throws CallBackException {
        if(!(notifyValue.getData() instanceof NotifyOrder)){
            throw new IllegalArgumentException("notifyValue.getData()必须是 NotifyOrder 对象!");
        }
        this.doNotifyOrderPay((NotifyValue<NotifyOrder>)notifyValue);
    }

    protected void doPrepareOrder(Order platformOrder, AppOrderResponsePay responsePay){
        logger.info("默认实现: 执行保存'AppOrderResponsePay'订单操作，order={}", platformOrder);
    }

    protected void doPrepareOrder(Order platformOrder, ScanOrderResponsePay responsePay){
        logger.info("默认实现: 执行保存'ScanOrderResponsePay'订单操作，order={}", platformOrder);
    }

    /**
     * 执行保存订单：公众号H5方式。
     * @param platformOrder
     * @param responsePay
     * @date 2023-06-11
     */
    protected void doPrepareOrder(Order platformOrder, H5ResponsePay responsePay){
        logger.info("默认实现: 执行保存'H5ResponsePay'订单操作，order={}", platformOrder);
    }

    protected void doNotifyOrderPay(NotifyValue<NotifyOrder> notifyValue){
        logger.info("默认实现: 接收支付通知，notifyValue={}", notifyValue);
    }
}
