package com.walker.pay.wechat.v2;

import com.walker.infrastructure.arguments.Variable;
import com.walker.pay.AbstractPayContext;
import com.walker.pay.wechat.Constants;

public class WechatV2PayContext extends AbstractPayContext {

    /**
     * 返回公众号，应用ID
     * @return
     */
    public Variable getAppIdConfig(){
        return this.getConfigVariable(Constants.CONFIG_KEY_APP_ID);
    }

    /**
     * 返回商户号
     * @return
     */
    public Variable getMchIdConfig(){
        return this.getConfigVariable(Constants.CONFIG_KEY_MCH_ID);
    }

    /**
     * 返回公众号，签名密钥
     * @return
     */
    public Variable getApiKeyConfig(){
        return this.getConfigVariable(Constants.CONFIG_KEY_API_KEY);
    }


    /**
     * 返回小程序，应用ID
     * @return
     * @date 2023-09-15
     */
    public Variable getRoutineAppId(){
        return this.getConfigVariable(Constants.CONFIG_KEY_APP_ID_ROUTINE);
    }

    /**
     * 返回小程序，签名密钥
     * @return
     * @date 2023-09-15
     */
    public Variable getRoutineSecret(){
        return this.getConfigVariable(Constants.CONFIG_KEY_API_KEY_ROUTINE);
    }

    /**
     * 返回小程序，商户号
     * @return
     * @date 2023-09-15
     */
    public Variable getRoutineMchId(){
        return this.getConfigVariable(Constants.CONFIG_KEY_MCH_ID_ROUTINE);
    }
}
