/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.wechat;

import com.walker.infrastructure.arguments.Variable;
import com.walker.infrastructure.utils.KeyValue;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Order;
import com.walker.pay.OrderGenerator;
import com.walker.pay.OrderStatusQuery;
import com.walker.pay.PayChannel;
import com.walker.pay.PayContext;
import com.walker.pay.PayStatus;
import com.walker.pay.PayType;
import com.walker.pay.ServiceProvider;
import com.walker.pay.response.OrderStatusResponsePay;
import com.walker.pay.support.SimplePayEngineProvider;
import com.walker.pay.wechat.v2.AppOrderGenerator;
import com.walker.pay.wechat.v2.H5OrderGenerator;
import com.walker.pay.wechat.v2.RoutineOrderGenerator;
import com.walker.pay.wechat.v2.ScanOrderGenerator;
import com.walker.pay.wechat.v2.SignUtils;
import com.walker.pay.wechat.v2.WechatV2PayContext;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class WechatV2PayEngineProvider
extends SimplePayEngineProvider {
    private Map<String, OrderGenerator> orderGeneratorMap = new HashMap<String, OrderGenerator>(8);
    private RestTemplate restTemplate;

    public WechatV2PayEngineProvider(RestTemplate restTemplate) {
        if (restTemplate == null) {
            throw new IllegalArgumentException("RestTemplate is required!");
        }
        this.restTemplate = restTemplate;
        this.init();
    }

    private void init() {
        this.setServiceProvider(ServiceProvider.Wechat);
        this.setVersion("v2");
        this.setPayChannel(PayChannel.ProviderDirect);
        ScanOrderGenerator scanOrderGenerator = new ScanOrderGenerator(this.restTemplate);
        AppOrderGenerator appOrderGenerator = new AppOrderGenerator(this.restTemplate);
        H5OrderGenerator h5OrderGenerator = new H5OrderGenerator(this.restTemplate);
        this.orderGeneratorMap.put("NATIVE", (OrderGenerator)scanOrderGenerator);
        this.orderGeneratorMap.put("APP", (OrderGenerator)appOrderGenerator);
        this.orderGeneratorMap.put("JSAPI", (OrderGenerator)h5OrderGenerator);
        RoutineOrderGenerator routineOrderGenerator = new RoutineOrderGenerator(this.restTemplate);
        this.orderGeneratorMap.put("ROUTINE", (OrderGenerator)routineOrderGenerator);
    }

    protected String acquireProviderPayType(ServiceProvider serviceProvider, PayType payType, PayChannel payChannel) {
        if (payType == PayType.Scan) {
            return "NATIVE";
        }
        if (payType == PayType.App) {
            return "APP";
        }
        if (payType == PayType.H5) {
            return "JSAPI";
        }
        if (payType == PayType.Applet) {
            return "ROUTINE";
        }
        throw new UnsupportedOperationException("\u4ee3\u7801\u672a\u5b9e\u73b0\u7b2c\u4e09\u65b9\u652f\u4ed8\u7c7b\u578b\u8f6c\u6362");
    }

    protected OrderGenerator acquireOrderGenerator(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        return this.orderGeneratorMap.get(providerPayType);
    }

    protected boolean verifySign(Object notifyData) throws Exception {
        return true;
    }

    protected PayContext acquirePayContext(String providerPayType, Order platformOrder, Map<String, Variable> configuration) {
        WechatV2PayContext payContext = new WechatV2PayContext();
        payContext.setConfigVariable(configuration.get("PAY.WX.APPID"));
        payContext.setConfigVariable(configuration.get("PAY.WX.MCH_ID"));
        payContext.setConfigVariable(configuration.get("PAY.WX.API_KEY"));
        payContext.setConfigVariable(configuration.get("routine_appid"));
        payContext.setConfigVariable(configuration.get("pay_routine_key"));
        payContext.setConfigVariable(configuration.get("pay_routine_mchid"));
        return payContext;
    }

    protected OrderStatusQuery acquireOrderStatusQuery(Order order) {
        throw new UnsupportedOperationException("\u6ca1\u5199\u4ee3\u7801\u5462!");
    }

    protected OrderStatusResponsePay invokeOrderStatus(OrderStatusQuery orderStatusQuery) {
        LinkedList<KeyValue<String, String>> packageParams = new LinkedList<KeyValue<String, String>>();
        packageParams.add(new KeyValue((Object)"appid", (Object)orderStatusQuery.getAppId()));
        packageParams.add(new KeyValue((Object)"mch_id", (Object)orderStatusQuery.getMerchantId()));
        packageParams.add(new KeyValue((Object)"nonce_str", (Object)StringUtils.generateRandomNumber((int)6)));
        packageParams.add(new KeyValue((Object)"out_trade_no", (Object)orderStatusQuery.getTradeNo()));
        packageParams.add(new KeyValue((Object)"sign_type", (Object)"MD5"));
        String sign = SignUtils.getPackageSign(packageParams, orderStatusQuery.getApiKey());
        packageParams.add((KeyValue<String, String>)new KeyValue((Object)"sign", (Object)sign));
        String request = SignUtils.toXml(packageParams);
        ResponseEntity entity = this.restTemplate.postForEntity("https://api.mch.weixin.qq.com/pay/orderquery", (Object)request, String.class, new Object[0]);
        if (entity == null) {
            throw new RuntimeException("\u8c03\u7528'\u5fae\u4fe1H5'\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u7a7a\u6570\u636e, trade_no = " + orderStatusQuery.getTradeNo());
        }
        Map<String, String> responseMap = SignUtils.decodeXml((String)entity.getBody());
        if (responseMap == null) {
            throw new RuntimeException("\u8c03\u7528'\u5fae\u4fe1H5'\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u6570\u636e\u8f6c\u6362\u4e3a\u7a7a: SignUtils.decodeXml() == null");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(responseMap.toString());
        }
        OrderStatusResponsePay responsePay = new OrderStatusResponsePay();
        if (responseMap.get("return_code").equals("FAIL")) {
            responsePay.setStatus(false);
            responsePay.setMessage(responseMap.get("return_msg"));
        } else if (responseMap.get("result_code").equals("FAIL")) {
            responsePay.setStatus(false);
            responsePay.setMessage(responseMap.get("err_code_des"));
            this.logger.error("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8c03\u7528\u6210\u529f\uff0c\u4f46\u8fd4\u56de\u9519\u8bef\u7ed3\u679c:" + responseMap.get("err_code"));
        } else {
            responsePay.setStatus(true);
            String tradeState = responseMap.get("trade_state");
            if (tradeState.equals("CLOSED")) {
                responsePay.setPayStatus(PayStatus.Closed);
                responsePay.setMessage("\u5df2\u5173\u95ed");
            } else if (tradeState.equals("USERPAYING")) {
                responsePay.setPayStatus(PayStatus.Paying);
                responsePay.setMessage("\u6b63\u5728\u652f\u4ed8\u4e2d");
            } else if (tradeState.equals("NOTPAY")) {
                responsePay.setPayStatus(PayStatus.NotPay);
                responsePay.setMessage("\u672a\u652f\u4ed8");
            } else if (tradeState.equals("REFUND")) {
                responsePay.setPayStatus(PayStatus.Refund);
                responsePay.setMessage("\u8f6c\u5165\u9000\u6b3e");
            } else if (tradeState.equals("PAYERROR")) {
                responsePay.setPayStatus(PayStatus.Error);
                responsePay.setMessage("\u652f\u4ed8\u5931\u8d25");
            } else if (tradeState.equals("REVOKED")) {
                responsePay.setPayStatus(PayStatus.Error);
                responsePay.setMessage("\u5df2\u64a4\u9500(\u5237\u5361\u652f\u4ed8) ");
            } else if (tradeState.equals("SUCCESS")) {
                responsePay.setPayStatus(PayStatus.Success);
                responsePay.setUserPayMoney(Long.parseLong(responseMap.get("cash_fee")));
                responsePay.setTotalMoney(Long.parseLong(responseMap.get("total_fee")));
                responsePay.setPaySuccessTime(responseMap.get("time_end"));
                responsePay.setOrderId(responseMap.get("out_trade_no"));
                responsePay.setTradeNo(responseMap.get("transaction_id"));
                responsePay.setAppId(orderStatusQuery.getAppId());
                responsePay.setMerchantId(orderStatusQuery.getMerchantId());
                responsePay.setProviderPayType(responseMap.get("trade_type"));
            } else {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u5fae\u4fe1\u8fd4\u56de\u7684\u652f\u4ed8\u7c7b\u578b\uff1a" + tradeState);
            }
        }
        return responsePay;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public String generateNotifyResponse(boolean success) {
        if (success) {
            return SignUtils.toXmlNotifyStatus("SUCCESS", "OK");
        }
        return SignUtils.toXmlNotifyStatus("FAIL", "FAIL");
    }
}

