/*
 * Decompiled with CFR 0.152.
 */
package com.walker.pay.wechat.v2;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.pay.Convertor;
import com.walker.pay.NotifyValue;
import com.walker.pay.PayChannel;
import com.walker.pay.wechat.v2.NotifyOrder;
import com.walker.pay.wechat.v2.SignUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotifyOrderConvertor
implements Convertor<NotifyValue<NotifyOrder>> {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());

    public NotifyValue<NotifyOrder> toGenericObject(Object data) {
        Map<String, String> paramMap = SignUtils.decodeXml(data.toString());
        String return_code = paramMap.get("return_code");
        if (StringUtils.isEmpty((String)return_code)) {
            throw new IllegalArgumentException("[wxPayNotify]\u8c03\u7528\u53c2\u6570\u9519\u8bef\uff1areturn_code\u4e0d\u5b58\u5728");
        }
        NotifyValue notifyValue = new NotifyValue();
        String resultCode = paramMap.get("result_code");
        if (return_code.equals("SUCCESS") && resultCode != null && resultCode.equals("SUCCESS")) {
            this.logger.debug("...........\u63a5\u6536\u5230\u5fae\u4fe1\u901a\u77e5\uff1a" + paramMap);
            notifyValue.setStatus(true);
            notifyValue.setSource(data);
            notifyValue.setOrderId(paramMap.get("out_trade_no"));
            notifyValue.setCreateTime(paramMap.get("time_end"));
            notifyValue.setTradeNo(paramMap.get("transaction_id"));
            notifyValue.setBuyerId(paramMap.get("openid"));
            notifyValue.setDataType("test");
            notifyValue.setId(notifyValue.getTradeNo());
            notifyValue.setPayChannel(PayChannel.WechatPay);
            if (paramMap.containsKey("trade_type")) {
                String tradeType = paramMap.get("trade_type");
                notifyValue.setTradeType(tradeType);
            }
            NotifyOrder notifyOrder = new NotifyOrder();
            notifyOrder.setTotalMoney(Long.parseLong(paramMap.get("total_fee")));
            notifyOrder.setOpenId(notifyValue.getBuyerId());
            notifyOrder.setDeviceInfo(paramMap.get("device_info"));
            notifyOrder.setAttach(paramMap.get("attach"));
            notifyValue.setData((Object)notifyOrder);
        }
        return notifyValue;
    }
}

