/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push.mail;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.mail.MailSenderInfo;
import com.walker.push.mail.MyAuthenticator;
import com.walker.push.util.PushUtils;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public abstract class MailPush
extends AbstractPushObject<MailSenderInfo> {
    private MyAuthenticator authenticator = null;
    private String mailServerHost;
    private String mailServerPort;
    private String fromAddress;
    private String fromPassword;

    public MailPush() {
        this.setId("mail");
        this.setName("\u90ae\u4ef6");
    }

    protected PushResult doPushContent(Notification notification, List<MailSenderInfo> data) throws PushException {
        PushResult pushResult = PushUtils.acquireSuccessPushResult();
        for (MailSenderInfo mailInfo : data) {
            Properties pro = mailInfo.getProperties();
            Session sendMailSession = Session.getDefaultInstance((Properties)pro, (Authenticator)this.authenticator);
            try {
                MimeMessage mailMessage = new MimeMessage(sendMailSession);
                InternetAddress from = new InternetAddress(mailInfo.getFromAddress());
                mailMessage.setFrom((Address)from);
                InternetAddress to = new InternetAddress(mailInfo.getToAddress());
                mailMessage.setRecipient(Message.RecipientType.TO, (Address)to);
                mailMessage.setSubject(mailInfo.getSubject());
                mailMessage.setSentDate(new Date());
                String mailContent = mailInfo.getContent();
                mailMessage.setText(mailContent);
                Transport.send((Message)mailMessage);
                this.logger.debug("\u6210\u529f\u53d1\u9001'\u901a\u77e5\u90ae\u4ef6': {}", (Object)mailContent);
            }
            catch (Exception ex) {
                this.logger.error("\u53d1\u9001'\u901a\u77e5\u90ae\u4ef6'\u5931\u8d25: " + mailInfo.getContent(), (Throwable)ex);
                pushResult.setCode(99);
                pushResult.setText(ex.getMessage());
                pushResult.addOneFailed(mailInfo.getUser());
            }
        }
        return pushResult;
    }

    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.Mail;
    }

    public List<MailSenderInfo> translateToTarget(Notification notification) {
        ArrayList<MailSenderInfo> data = new ArrayList<MailSenderInfo>(2);
        MailSenderInfo mailSenderInfo = null;
        String toAddress = null;
        for (String user : notification.getReceiverList()) {
            mailSenderInfo = new MailSenderInfo();
            mailSenderInfo.setMailServerHost(this.mailServerHost);
            mailSenderInfo.setMailServerPort(this.mailServerPort);
            mailSenderInfo.setValidate(true);
            mailSenderInfo.setUserName(this.fromAddress);
            mailSenderInfo.setPassword(this.fromPassword);
            mailSenderInfo.setFromAddress(this.fromAddress);
            mailSenderInfo.setUser(user);
            toAddress = user.indexOf("@") > 0 ? user : this.getUserMail(user);
            if (StringUtils.isEmpty((String)toAddress)) {
                this.logger.error("\u6839\u636e\u7528\u6237id\u672a\u627e\u5230'email'\u5730\u5740\uff0c\u8be5\u63a8\u9001\u6d88\u606f\u5ffd\u7565\u3002user={}", (Object)user);
                continue;
            }
            mailSenderInfo.setToAddress(toAddress);
            mailSenderInfo.setSubject(notification.getTitle());
            mailSenderInfo.setContent(notification.getContent());
            data.add(mailSenderInfo);
        }
        return data;
    }

    public void startup() {
        if (StringUtils.isEmpty((String)this.fromAddress) || StringUtils.isEmpty((String)this.fromPassword)) {
            throw new IllegalArgumentException("\u9700\u8981\u5148\u8bbe\u7f6e\u90ae\u4ef6\u53d1\u9001\u8005\u4fe1\u606f: fromAddress, fromPassword!");
        }
        if (this.authenticator == null) {
            this.authenticator = new MyAuthenticator(this.fromAddress, this.fromPassword);
        }
    }

    protected abstract String getUserMail(String var1);

    public void setMailServerHost(String mailServerHost) {
        this.mailServerHost = mailServerHost;
    }

    public void setMailServerPort(String mailServerPort) {
        this.mailServerPort = mailServerPort;
    }

    public void setFromAddress(String fromAddress) {
        this.fromAddress = fromAddress;
    }

    public void setFromPassword(String fromPassword) {
        this.fromPassword = fromPassword;
    }
}

