/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push.rocketmq;

import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.queue.MqBaseMessage;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.support.MessageBuilder;

public class RocketMQEnhanceTemplate {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private boolean enabledIsolation = true;
    private String environmentName = "";
    private RocketMQTemplate template;

    public <T extends MqBaseMessage> SendResult sendAndWait(String topic, T message, int delayLevel) {
        Message sendMessage = MessageBuilder.withPayload(message).setHeader("KEYS", (Object)message.getKey()).build();
        return this.template.syncSend(topic, sendMessage, 3000L, delayLevel);
    }

    public <T extends MqBaseMessage> void sendAsync(String topic, T message, SendCallback callback) {
        this.sendAsync(topic, message, callback, 3000L, 0);
    }

    public <T extends MqBaseMessage> void sendAsync(String topic, T message, SendCallback callback, long timeout, int delayLevel) {
        if (StringUtils.isEmpty((String)topic)) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u53d1\u9001\u6d88\u606f\uff0ctopic\u4e3a\u7a7a");
        }
        Message sendMessage = MessageBuilder.withPayload(message).setHeader("KEYS", (Object)message.getKey()).build();
        if (delayLevel > 0) {
            this.template.asyncSend(topic, sendMessage, callback, timeout, delayLevel);
        } else {
            this.template.asyncSend(topic, sendMessage, callback);
        }
    }

    public String buildDestination(String topic, String tag) {
        topic = this.reBuildTopic(topic);
        return topic + ":" + tag;
    }

    private String reBuildTopic(String topic) {
        if (this.enabledIsolation && StringUtils.hasText((String)this.environmentName)) {
            return topic + "_" + this.environmentName;
        }
        return topic;
    }

    public <T extends MqBaseMessage> SendResult send(String topic, String tag, T message) {
        return this.send(this.buildDestination(topic, tag), message);
    }

    public <T extends MqBaseMessage> SendResult send(String destination, T message) {
        Message sendMessage = MessageBuilder.withPayload(message).setHeader("KEYS", (Object)message.getKey()).build();
        SendResult sendResult = this.template.syncSend(destination, sendMessage);
        try {
            this.logger.debug("[{}]\u540c\u6b65\u6d88\u606f[{}]\u53d1\u9001\u7ed3\u679c[{}]", new Object[]{destination, JsonUtils.objectToJsonString(message), JsonUtils.objectToJsonString((Object)sendResult)});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sendResult;
    }

    public <T extends MqBaseMessage> SendResult send(String topic, String tag, T message, int delayLevel) {
        return this.send(this.buildDestination(topic, tag), message, delayLevel);
    }

    public <T extends MqBaseMessage> SendResult send(String destination, T message, int delayLevel) {
        Message sendMessage = MessageBuilder.withPayload(message).setHeader("KEYS", (Object)message.getKey()).build();
        SendResult sendResult = this.template.syncSend(destination, sendMessage, 3000L, delayLevel);
        try {
            this.logger.debug("[{}]\u5ef6\u8fdf\u7b49\u7ea7[{}]\u6d88\u606f[{}]\u53d1\u9001\u7ed3\u679c[{}]", new Object[]{destination, delayLevel, JsonUtils.objectToJsonString(message), JsonUtils.objectToJsonString((Object)sendResult)});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sendResult;
    }

    public RocketMQTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(RocketMQTemplate template) {
        this.template = template;
    }

    public void setEnabledIsolation(boolean enabledIsolation) {
        this.enabledIsolation = enabledIsolation;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }
}

