/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push.rocketmq;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.core.ApplicationBeanInitialized;
import com.walker.queue.AbstractQueueManager;
import com.walker.queue.QueueException;
import com.walker.tcp.ActionCallable;
import com.walker.tcp.ActionCallablePostProcessor;
import com.walker.tcp.Connection;
import com.walker.tcp.ConnectionManager;
import com.walker.tcp.Request;
import com.walker.tcp.Response;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class RocketQueueManager
extends AbstractQueueManager
implements ApplicationBeanInitialized {
    private ThreadPoolTaskExecutor executor = null;
    private ConnectionManager connectionManager;

    public void startup() {
    }

    public void push(String key, Object data, Object option) throws QueueException {
        if (data == null) {
            throw new QueueException("request is required!");
        }
        if (!Request.class.isAssignableFrom(data.getClass())) {
            throw new QueueException("\u8bf7\u6c42\u5bf9\u8c61\u5fc5\u987b\u662f: " + Request.class.getName());
        }
        Request request = (Request)data;
        this.executor.execute((Runnable)new AsyncProcessRequestTask(request));
    }

    protected void processFailed(Request<?> request) {
        this.logger.error("(\u8d1f\u8f7d)tcp\u6d88\u606f\u5904\u7406\u5931\u8d25\uff0c\u53ef\u80fd\u8fde\u63a5\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u5173\u95ed\uff0c\u8bb0\u5f55\u65e5\u5fd7\uff1a" + request.toString());
    }

    protected void processSuccess(Request<?> request) {
        this.logger.debug("(\u8d1f\u8f7d)tcp\u6d88\u606f\u5904\u7406\u6210\u529f\uff1a" + request.getProtocolNum());
    }

    public void setExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }

    public void setConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    private class AsyncProcessRequestTask
    implements Runnable {
        private Request<?> request;

        public AsyncProcessRequestTask(Request<?> request) {
            this.request = request;
        }

        @Override
        public void run() {
            ActionCallable action = ActionCallablePostProcessor.getAction((String)this.request.getProtocolNum());
            if (action == null) {
                throw new ApplicationRuntimeException("action\u672a\u5b9a\u4e49\uff0cprotocol = " + this.request.getProtocolNum());
            }
            try {
                if (!this.request.isRequireResponse()) {
                    action.action(this.request);
                    return;
                }
                Response response = action.action(this.request);
                response.setName(this.request.getName());
                Connection conn = RocketQueueManager.this.connectionManager.getConnectionByName(this.request.getName());
                if (conn == null || !conn.isConnected()) {
                    RocketQueueManager.this.processFailed(this.request);
                    return;
                }
                conn.write(response);
                RocketQueueManager.this.processSuccess(this.request);
            }
            catch (Exception ex) {
                RocketQueueManager.this.processFailed(this.request);
                RocketQueueManager.this.logger.error("\u6267\u884caction(\u8d1f\u8f7d)\u9519\u8bef\uff1a" + ex.getMessage(), (Throwable)ex);
            }
        }
    }
}

