package com.walker.push.rocketmq;

import com.walker.infrastructure.utils.StringUtils;
import org.apache.rocketmq.spring.support.DefaultRocketMQListenerContainer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

/**
 * 消息队列，环境隔离增强Bean配置，如果设置环境参数，则会自动在主题后面追加参数。
 * <pre>
 *     如：chat_topic_dev, chat_topic_prod
 * </pre>
 * @author 时克英
 * @date 2023-09-18
 */
@Deprecated
public class EnvironmentIsolationPostProcessor implements BeanPostProcessor {

    /**
     * 在装载Bean之前实现参数修改
     */
    @Override
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if(bean instanceof DefaultRocketMQListenerContainer){
            DefaultRocketMQListenerContainer container = (DefaultRocketMQListenerContainer) bean;
            //拼接Topic
            if(enabledIsolation && StringUtils.hasText(environmentName)){
                container.setTopic(String.join(StringUtils.STRING_UNDERLINE, container.getTopic(), environmentName));
            }
            return container;
        }
        return bean;
    }

    public void setEnabledIsolation(boolean enabledIsolation) {
        this.enabledIsolation = enabledIsolation;
    }

    public void setEnvironmentName(String environmentName) {
        this.environmentName = environmentName;
    }

    //    @Value("${rocketmq.enhance.enabledIsolation:true}")
    private boolean enabledIsolation = true;
//    @Value("${rocketmq.enhance.environment:''}")
    private String environmentName = StringUtils.EMPTY_STRING;
}
