/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push.alidy;

import com.aliyun.auth.credentials.Credential;
import com.aliyun.auth.credentials.provider.ICredentialProvider;
import com.aliyun.auth.credentials.provider.StaticCredentialProvider;
import com.aliyun.sdk.service.dysmsapi20170525.AsyncClient;
import com.aliyun.sdk.service.dysmsapi20170525.DefaultAsyncClientBuilder;
import com.aliyun.sdk.service.dysmsapi20170525.models.SendSmsRequest;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.infrastructure.utils.StringUtils;
import com.walker.push.Notification;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.SmsMessage;
import com.walker.push.support.AbstractSmsPush;
import com.walker.push.util.PushUtils;
import darabonba.core.client.ClientOverrideConfiguration;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public abstract class DySmsPush
extends AbstractSmsPush {
    private AsyncClient client = null;
    private String accessKeyId;
    private String accessKeySecret;
    private String signName;
    private String region;

    public DySmsPush() {
        this.setId("alidy_sms_push");
        this.setName("\u5927\u9c7c\u77ed\u4fe1\u63a8\u9001");
        this.setSupportAsync(true);
    }

    public void startup() {
        if (StringUtils.isEmpty((String)this.accessKeyId) || StringUtils.isEmpty((String)this.accessKeySecret) || StringUtils.isEmpty((String)this.signName) || StringUtils.isEmpty((String)this.region)) {
            throw new IllegalArgumentException("\u8bf7\u5148\u8bbe\u7f6e\u77ed\u4fe1\u914d\u7f6e\uff1a" + this.getName());
        }
        StaticCredentialProvider provider = StaticCredentialProvider.create((Credential)Credential.builder().accessKeyId(this.accessKeyId).accessKeySecret(this.accessKeySecret).build());
        this.client = (AsyncClient)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)((DefaultAsyncClientBuilder)AsyncClient.builder().region(this.region)).credentialsProvider((ICredentialProvider)provider)).overrideConfiguration(ClientOverrideConfiguration.create().setEndpointOverride("dysmsapi.aliyuncs.com"))).build();
        this.logger.info("\u521d\u59cb\u5316\uff1a\u5927\u9c7c\u77ed\u4fe1\u63a8\u9001\u8005");
    }

    protected PushResult doPushContent(Notification notification, List<SmsMessage> data) throws PushException {
        if (notification.getBroadcast()) {
            throw new IllegalStateException("\u77ed\u4fe1\u63a8\u9001\uff0c\u65e0\u6cd5\u8bbe\u7f6e\u4e3a\u5e7f\u64ad!");
        }
        PushResult pushResult = PushUtils.acquireSuccessPushResult();
        SmsMessage smsMessage = data.get(0);
        String phoneNumbers = StringUtils.collectionToDelimitedString((Collection)smsMessage.getMobileList(), (String)",");
        String templateParam = null;
        try {
            templateParam = JsonUtils.objectToJsonString((Object)smsMessage.getTemplateParam());
        }
        catch (Exception e) {
            throw new PushException(notification.getId(), "\u77ed\u4fe1json\u8f6c\u6362\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        SendSmsRequest sendSmsRequest = SendSmsRequest.builder().phoneNumbers(phoneNumbers).signName(this.signName).templateCode(smsMessage.getTemplateId()).templateParam(templateParam).build();
        CompletionStage response = this.client.sendSms(sendSmsRequest).whenComplete((res, ex) -> {
            if (ex != null) {
                this.getPushStatusListener().onException(notification, ex.getMessage(), this.getNotificationChannel());
            } else {
                this.getPushStatusListener().onSuccess(notification, (Object)res.getBody().getBizId(), this.getNotificationChannel());
            }
        });
        try {
            ((CompletableFuture)response).get();
        }
        catch (Exception e) {
            throw new PushException(notification.getId(), e.getMessage(), (Throwable)e);
        }
        return pushResult;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getSignName() {
        return this.signName;
    }

    public void setSignName(String signName) {
        this.signName = signName;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }
}

