package com.walker.push.wx;

import java.io.Serializable;

/**
 * 跳小程序所需数据，不需跳小程序可不用传该数据
 * @date 2023-08-27
 */
public class MiniProgram implements Serializable {

    public MiniProgram(){}

    /**
     * 所需跳转到的小程序appid（该小程序appid必须与发模板消息的公众号是绑定关联关系，暂不支持小游戏）
     * @return
     */
    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    /**
     * 所需跳转到小程序的具体页面路径，支持带参数,（示例index?foo=bar），要求该小程序已发布，暂不支持小游戏
     * @return
     */
    public String getPagepath() {
        return pagepath;
    }

    public void setPagepath(String pagepath) {
        this.pagepath = pagepath;
    }

    private String appid;
    private String pagepath;

    @Override
    public String toString() {
        return "MiniProgram{" +
                "appid='" + appid + '\'' +
                ", pagepath='" + pagepath + '\'' +
                '}';
    }
}
