package com.walker.push.wx;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.util.PushUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WeixinPublicPush extends AbstractPushObject<MessageTemplate> {

    /** 公众号发送模板消息的url */
    public static final String WECHAT_PUBLIC_SEND_TEMPLATE_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={0}";

    public WeixinPublicPush(){
        this.setId(NotificationChannel.INDEX_WX);
        this.setName(NotificationChannel.NAME_WX);
    }

    @Override
    public void startup() {

    }

    @Override
    protected PushResult doPushContent(Notification notification, List<MessageTemplate> data) throws PushException {
        if(this.restTemplate == null){
            throw new IllegalStateException("RestTemplate未配置");
        }

        // 每次只能发送一个人消息
        // getReceiverList中只有一个值，access_token
        String url = MessageFormat.format(WECHAT_PUBLIC_SEND_TEMPLATE_URL, notification.getReceiverList().get(0));
        String request = null;
        try {
            request = JsonUtils.objectToJsonString(data.get(0));
        } catch (Exception e) {
            throw new ApplicationRuntimeException("MessageTemplate转Json错误:" + e.getMessage(), e);
        }
        ResponseEntity<Map> responseEntity = this.restTemplate.postForEntity(url, request, Map.class);
        if(responseEntity == null){
            throw new ApplicationRuntimeException("微信平台接口异常(发送公众号消息模板)，没任何数据返回！");
        }

        logger.debug(responseEntity.getBody().toString());

//        ObjectNode objectNode = null;
//        try {
//            objectNode = JsonUtils.jsonStringToObjectNode(responseEntity.getBody());
//        } catch (Exception e) {
//            throw new ApplicationRuntimeException("string转ObjectNode错误：" + e.getMessage(), e);
//        }
        /*if (objectNode.has("errcode") && !objectNode.get("errcode").asText().equals("0")) {
            if (objectNode.has("errmsg")) {
                // 保存到微信异常表
//                    wxExceptionDispose(data, StrUtil.format("微信获取accessToken异常，{}端", type));
//                throw new ApplicationRuntimeException("微信接口调用失败：" + objectNode.get("errcode") + objectNode.get("errmsg"));
                return PushUtils.acquireFailedPushResult(objectNode.get("errcode").asText() + objectNode.get("errmsg"), "");
            }
        }*/

        Map<String, Object> resultMap = responseEntity.getBody();
        if(resultMap.containsKey("errcode") && !resultMap.get("errcode").toString().equals("0")){
            logger.error("调用微信公众号消息接口返回错误:{}", resultMap);
            return PushUtils.acquireFailedPushResult(resultMap.get("errmsg").toString(), "");
        }

        return PushUtils.acquireSuccessPushResult();
    }

    @Override
    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.OfficialAccount;
    }

    @Override
    public List<MessageTemplate> translateToTarget(Notification notification) {
        List<MessageTemplate> data = new ArrayList<>(2);
        MessageTemplate messageTemplate = null;

        try {
            messageTemplate = JsonUtils.jsonStringToObject(notification.getContent(), MessageTemplate.class);
        } catch (Exception e) {
            throw new RuntimeException("消息内容json(MessageTemplate)转换错误:" + e.getMessage(), e);
        }
        data.add(messageTemplate);
        return data;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    private RestTemplate restTemplate;
}
