/*
 * Decompiled with CFR 0.152.
 */
package com.walker.push.wx;

import com.walker.infrastructure.ApplicationRuntimeException;
import com.walker.infrastructure.utils.JsonUtils;
import com.walker.push.AbstractPushObject;
import com.walker.push.Notification;
import com.walker.push.NotificationChannel;
import com.walker.push.PushException;
import com.walker.push.PushResult;
import com.walker.push.util.PushUtils;
import com.walker.push.wx.MessageTemplate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class WeixinPublicPush
extends AbstractPushObject<MessageTemplate> {
    public static final String WECHAT_PUBLIC_SEND_TEMPLATE_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token={0}";
    private RestTemplate restTemplate;

    public WeixinPublicPush() {
        this.setId("wx");
        this.setName("\u516c\u4f17\u53f7");
    }

    public void startup() {
    }

    protected PushResult doPushContent(Notification notification, List<MessageTemplate> data) throws PushException {
        if (this.restTemplate == null) {
            throw new IllegalStateException("RestTemplate\u672a\u914d\u7f6e");
        }
        String url = MessageFormat.format(WECHAT_PUBLIC_SEND_TEMPLATE_URL, notification.getReceiverList().get(0));
        String request = null;
        try {
            request = JsonUtils.objectToJsonString((Object)data.get(0));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("MessageTemplate\u8f6cJson\u9519\u8bef:" + e.getMessage(), (Throwable)e);
        }
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)request, Map.class, new Object[0]);
        if (responseEntity == null) {
            throw new ApplicationRuntimeException("\u5fae\u4fe1\u5e73\u53f0\u63a5\u53e3\u5f02\u5e38(\u53d1\u9001\u516c\u4f17\u53f7\u6d88\u606f\u6a21\u677f)\uff0c\u6ca1\u4efb\u4f55\u6570\u636e\u8fd4\u56de\uff01");
        }
        this.logger.debug(((Map)responseEntity.getBody()).toString());
        Map resultMap = (Map)responseEntity.getBody();
        if (resultMap.containsKey("errcode") && !resultMap.get("errcode").toString().equals("0")) {
            this.logger.error("\u8c03\u7528\u5fae\u4fe1\u516c\u4f17\u53f7\u6d88\u606f\u63a5\u53e3\u8fd4\u56de\u9519\u8bef:{}", (Object)resultMap);
            return PushUtils.acquireFailedPushResult((String)resultMap.get("errmsg").toString(), (String)"");
        }
        return PushUtils.acquireSuccessPushResult();
    }

    public NotificationChannel getNotificationChannel() {
        return NotificationChannel.OfficialAccount;
    }

    public List<MessageTemplate> translateToTarget(Notification notification) {
        ArrayList<MessageTemplate> data = new ArrayList<MessageTemplate>(2);
        MessageTemplate messageTemplate = null;
        try {
            messageTemplate = (MessageTemplate)JsonUtils.jsonStringToObject((String)notification.getContent(), MessageTemplate.class);
        }
        catch (Exception e) {
            throw new RuntimeException("\u6d88\u606f\u5185\u5bb9json(MessageTemplate)\u8f6c\u6362\u9519\u8bef:" + e.getMessage(), e);
        }
        data.add(messageTemplate);
        return data;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

