package com.walker.scheduler;

/**
 * 定义“不能找到采集源”异常。</p>
 * 在很多情况下，我们对需要采集的资源是需要管理的，例如：一卡通，<br>
 * 这些被称为采集源，它定义了需要采集内容的地址或者索引，<br>
 * 一旦这些采集源无法获取，系统将无法继续进行采集。
 * @author shikeying
 * @date 2016年1月27日
 *
 */
public class NotFoundGatherDataException extends RuntimeException {

	/**
	 * 
	 */
	private static final long serialVersionUID = -4623087345210609567L;

	public NotFoundGatherDataException(String db) {
		super("未找到要采集的定义数据：无法找到采集源");
	}
	
//	public DatabaseExistException(String msg) {
//		super(msg);
//	}
	
	public NotFoundGatherDataException(String msg, Throwable cause) {
		super(msg, cause);
	}
}
