package com.walker.scheduler;

/**
 * 调度引擎接口定义，主要用来存储调度的相关信息。</p>
 * 目前看来主要存储在MySQL数据库中，便于系统重启后能按照上次任务执行。
 * @author shikeying
 * @date 2015年12月24日
 *
 */
public interface ScheduleEngine {

	void setStatusStarted(int scheduleId);
	
	void setStatusRestarted(int scheduleId);
	
	void setStatusPaused(int scheduleId);
	
	void setStatusStoped(int scheduleId);
	
	/**
	 * 设置调度器状态为：任务执行完成并结束，此状态仅针对'一次性任务'有效。<br>
	 * 其他类型没有这个状态，只有'结束'
	 * @param scheduleId
	 */
	void setStatusDone(int scheduleId);
}
