package com.walker.scheduler;

import com.walker.infrastructure.arguments.ArgumentsManager;

/**
 * 调度器规范定义。</p>
 * <pre>
 * 1、start, stop, pause
 * 2、调度类型：仅执行一次、按照开始时间执行一次、在一定时间段反复执行
 * 3、执行频率：仅一次、可多次执行、
 * </pre>
 * @author shikeying
 * @date 2015年12月22日
 *
 */
public interface Scheduler {

	int getId();
	
	String getName();
	
	Option getOption();
	
	String getStoreId();
	
	long getStartTime();

	void start();
	
	void stop();
	
	void pause();
	
	void restart();

	/**
	 * 告诉调度器，任务调用设否要设置'终止条件'。</p>
	 * 因为通常一个任务在重复执行过程中，如果获取不到外部新的数据，继续执行就没有意义，<br>
	 * 因此通过该参数，系统可以在适当的时候暂停某个任务，来为其他任务分配资源。
	 * @param boo
	 */
	void setTaskTerminateCondition(boolean boo);
	
	/**
	 * 设置调度时间设置选项
	 * @param option
	 */
	void setOption(Option option);

	void setMaxFailedTimes(int maxFailedTimes);
	
	/**
	 * 设置调度存储引擎对象
	 * @param scheduleEngine
	 */
	void setScheduleEngine(ScheduleEngine scheduleEngine);

	boolean isStarted();

	boolean isPause();

	/**
	 * 返回执行任务如果没有采集到数据，是否终止该任务。<br>
	 * 如果返回<code>true</code>则终止任务执行。
	 * @return
	 */
	boolean isTaskTerminateCondition();
	
	/**
	 * 返回是否'核心'调度器，核心调度器不能够被人为管理（启动、停止等）。<br>
	 * 它只能被超级管理员控制，通常启动后不会被终止（除非超管干预）。
	 * @return
	 */
	boolean isKernelScheduler();
	
	void setArgumentManager(ArgumentsManager argumentManager);

	ArgumentsManager getArgumentManager();
}
