package com.walker.scheduler.impl;

import com.walker.scheduler.util.OptionUtils;

/**
 * 平台实现的“采集类型”调度器，特点是：无限循环，持续执行，无需设置周期。
 * @author 时克英
 * @date 2018-12-28
 *
 */
public abstract class ForeverScheduler extends TimedScheduler {

	// 如果执行调用后，未返回结果数据，就进入休眠（有休眠时间设置）
	private boolean sleepForNotFoundData = true;
	
	/**
	 * 设置参数：如果执行调用后，未返回结果数据，就进入休眠（有休眠时间设置）
	 * @param sleepForNotFoundData
	 */
	public void setSleepForNotFoundData(boolean sleepForNotFoundData) {
		this.sleepForNotFoundData = sleepForNotFoundData;
	}

	public ForeverScheduler(int id, String name){
		super(id, name);
		this.setOption(OptionUtils.combineEveryDay24HourOption());
	}
	
	@Override
	protected Object doRunOnce(Object[] inputParams) throws Exception {
		this.firstRunForLazy();
		Object result = this.onProcess(inputParams);
		if(result == null && this.sleepForNotFoundData){
			this.doChangeIntervalTime();
			logger.debug("~~~~~~~~~~~~~~~~~~~~ 没有数据采集，线程休眠一次：" + this.getTimeInterval());
		} else {
			this.doResetIntervalTime();
		}
		
		return result;
	}

	@Override
	protected Object[] getRunParameters(Object previousInvokeResult) {
		return null;
	}

}
