package com.walker.scheduler.impl;

import com.walker.scheduler.AbstractScheduler;

public abstract class ListeningScheduler extends AbstractScheduler {

	public ListeningScheduler(int id, String name
//			, DatabaseStore store
	) {
		super(id, name);
	}

	@Override
	protected Object runTask() throws Exception {
		return null;
	}

	@Override
	public void start() {
		if(!started){
			// 
			try {
				this.onStartScheduler();
				logger.info("调度器'" + this.getName() + "'启动......");
				started = true;
				scheduleEngine.setStatusStarted(this.getId());
			} catch (Exception e) {
				throw new IllegalStateException("启动'ListeningScheduler'失败："+e.getMessage(), e);
			}
		} else {
			throw new IllegalStateException("调度器已启动，调用状态错误。id = " + this.getId());
		}
		startTime = System.currentTimeMillis();
	}
	
	@Override
	public void pause() {
		throw new UnsupportedOperationException("监听类调度器不支持暂停方法");
	}
	
	@Override
	public void stop() {
		this.onStopScheduler();
		started = false;
		this.onStopScheduler();
		scheduleEngine.setStatusStoped(this.getId());
		logger.info("调度器'" + this.getName() + "'被停止运行......");
	}
	
	protected abstract void onStartScheduler() throws Exception;
	
	protected abstract void onStopScheduler();
}
