package com.walker.scheduler.impl;

import com.walker.scheduler.AbstractKernelScheduler;

import java.util.concurrent.TimeUnit;

/**
 * 平台定时调度器实现，该对象必须设置定时时间，支持：</p>
 * <pre>
 * 1、只执行一次（具体时间）
 * 2、周期执行（时间循环或时间范围内）
 * </pre>
 * @author 时克英
 * @date 2018-12-28
 *
 */
public abstract class TimedScheduler extends AbstractKernelScheduler {

	// 初始化状态，防止刚启动就执行，带了问题
	private boolean firstLazy = false;

	public TimedScheduler(int id, String name){
		super(id, name);
	}

	@Override
	protected Object doRunOnce(Object[] inputParams) throws Exception {
		this.firstRunForLazy();
		return this.onProcess(inputParams);
	}

	@Override
	protected Object[] getRunParameters(Object previousInvokeResult) {
		return null;
	}

	/**
	 * 业务调用实现，实际执行一次计算调用
	 * @param inputParams 每次getRunParameters()方法返回的参数
	 * @return 返回本次调用处理的结果数据，如果没有为空。可作为下次是否执行的凭证
	 */
	protected abstract Object onProcess(Object[] inputParams) throws Exception;
	
	protected void firstRunForLazy(){
		if(!firstLazy){
			try {
				// 让启动线程等待一会，防止系统还没启动完，就开始加载对象
				TimeUnit.SECONDS.sleep(10);
			} catch (InterruptedException e) {
				e.printStackTrace();
			} finally {
				firstLazy = true;
			}
		}
	}
}
