package com.walker.scheduler.util;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.scheduler.Option;

import java.util.ArrayList;
import java.util.List;

public class OptionUtils {

    /**
     * 返回调度时间选项：每天24小时
     * @return
     */
    public static final Option combineEveryDay24HourOption(){
        Option option = new Option();
        List<Integer[]> timeRanges = new ArrayList<Integer[]>(1);
        timeRanges.add(new Integer[]{0,24});
        option.setRangeTime(timeRanges);
        option.setTimeType(Option.TimeType.RANGE);
        option.setPeriodType(Option.PeriodType.FOREVER);
        return option;
    }

    /**
     * 组装一个每天在规定时间段范围的调度选项。
     * @param timeRanges 小时范围，每个Integer[]中2个值，分别对应'开始小时', '结束小时'
     * @return
     */
    public static final Option combineEveryDayHourRange(List<Integer[]> timeRanges){
        if(StringUtils.isEmptyList(timeRanges)){
            throw new IllegalArgumentException("请设置小时范围集合，如: [1,5],[10,12] etc.");
        }
        Option option = new Option();
        option.setRangeTime(timeRanges);
        option.setTimeType(Option.TimeType.RANGE);
        option.setPeriodType(Option.PeriodType.FOREVER);
        return option;
    }
}
