/*
 * Decompiled with CFR 0.152.
 */
package com.walker.scheduler;

import com.walker.scheduler.AbstractScheduler;
import com.walker.scheduler.Option;

public abstract class AbstractKernelScheduler
extends AbstractScheduler {
    private Object previousInvokeResult = "";
    private int invokeCount = 0;
    private static final long MORE_INTERVAL_TIME = 600000L;
    private long originalTimeInterval = 0L;
    private boolean timeIntervalChanged = false;
    private long waitSleepTime = 0L;
    private boolean allowIdleSleep = true;

    public boolean isAllowIdleSleep() {
        return this.allowIdleSleep;
    }

    public void setAllowIdleSleep(boolean allowIdleSleep) {
        this.allowIdleSleep = allowIdleSleep;
    }

    public void setWaitSleepTime(long waitSleepTime) {
        this.waitSleepTime = waitSleepTime;
    }

    public AbstractKernelScheduler(int id, String name) {
        super(id, name);
    }

    @Override
    protected Object runTask() throws Exception {
        if (this.originalTimeInterval == 0L) {
            this.originalTimeInterval = this.getTimeInterval();
        }
        if (this.allowIdleSleep && this.getInvokeCount() > 0) {
            if (this.isTimeIntervalChanged()) {
                if (this.previousInvokeResult != null) {
                    this.doResetIntervalTime();
                } else {
                    this.doChangeIntervalTime();
                }
            } else if (this.previousInvokeResult == null) {
                this.logger.debug("\u540e\u7eed\u4efb\u52a1\u8c03\u7528\u4e2d\uff0c\u4e0a\u6b21\u8c03\u7528\u6ca1\u6709\u8fd4\u56de\u6570\u636e\uff0c\u8c03\u5ea6\u7761\u7720\u3002currentGather = ");
                this.doChangeIntervalTime();
            }
        }
        Object[] inputParams = this.getRunParameters(this.previousInvokeResult);
        this.previousInvokeResult = this.doRunOnce(inputParams);
        if (this.invokeCount >= Integer.MAX_VALUE) {
            this.invokeCount = 0;
        }
        ++this.invokeCount;
        if (this.getOption().getPeriodType() == Option.PeriodType.NONE) {
            this.stop();
            return null;
        }
        return this.previousInvokeResult;
    }

    protected void doChangeIntervalTime() {
        if (this.waitSleepTime == 0L) {
            this.setTimeInterval(600000L);
        } else {
            this.setTimeInterval(this.waitSleepTime);
        }
        this.timeIntervalChanged = true;
    }

    protected void doResetIntervalTime() {
        this.setTimeInterval(this.originalTimeInterval);
        this.timeIntervalChanged = false;
        this.logger.debug("...........\u91c7\u96c6\u8c03\u5ea6\u65f6\u949f\u95f4\u9694\u88ab\u590d\u4f4d\uff0creset interval time\uff1a" + this.originalTimeInterval);
    }

    @Override
    public String getStoreId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isKernelScheduler() {
        return true;
    }

    public boolean isTimeIntervalChanged() {
        return this.timeIntervalChanged;
    }

    protected abstract Object[] getRunParameters(Object var1);

    protected abstract Object doRunOnce(Object[] var1) throws Exception;

    public int getInvokeCount() {
        return this.invokeCount;
    }
}

