/*
 * Decompiled with CFR 0.152.
 */
package com.walker.scheduler;

import com.walker.infrastructure.arguments.ArgumentsManager;
import com.walker.scheduler.NotFoundGatherDataException;
import com.walker.scheduler.Option;
import com.walker.scheduler.ScheduleEngine;
import com.walker.scheduler.Scheduler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScheduler
implements Scheduler {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private int id;
    private String name;
    private Option option = null;
    private long timeInterval = 5000L;
    protected long startTime = 0L;
    private long restartTime = 0L;
    private Thread kernelThread = null;
    public int nThreads = 1;
    public int nThreadQueue = 16;
    private ExecutorService executorService = null;
    private InternalTimerRunner timerRunner = new InternalTimerRunner();
    protected boolean started = false;
    private boolean taskTerminateCondition = false;
    private int maxFailedTimes = 0;
    private int currentFailedTime = 0;
    protected ScheduleEngine scheduleEngine = null;
    private boolean kernelScheduler = false;
    private ArgumentsManager argumentManager;

    public void setId(int id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ScheduleEngine getScheduleEngine() {
        return this.scheduleEngine;
    }

    public AbstractScheduler() {
    }

    public AbstractScheduler(int id, String name) {
        this.id = id;
        this.name = name;
        if (this.executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.nThreads, this.nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.nThreadQueue), new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    return t;
                }
            });
            this.executorService = threadPoolExecutor;
            this.logger.info("\u521d\u59cb\u5316\u4e86\u7ebf\u7a0b\u6c60\u5bf9\u8c61'executorService', nThreads=" + this.nThreads + ", nThreadQueue=" + this.nThreadQueue);
        }
    }

    @Override
    public String getStoreId() {
        throw new UnsupportedOperationException("\u8be5\u5c5e\u6027\u5e9f\u5f03");
    }

    public int getCurrentFailedTime() {
        return this.currentFailedTime;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Option getOption() {
        return this.option;
    }

    public long getTimeInterval() {
        return this.timeInterval;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    public long getRestartTime() {
        return this.restartTime;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isPause() {
        if (this.timerRunner != null) {
            return this.timerRunner.isPause();
        }
        return false;
    }

    @Override
    public boolean isTaskTerminateCondition() {
        return this.taskTerminateCondition;
    }

    @Override
    public boolean isKernelScheduler() {
        return this.kernelScheduler;
    }

    public void interruptKernelThread() {
        this.logger.debug("\u7ebf\u7a0b\u88ab\u5524\u9192\u4e00\u6b21\uff1a" + this.getName());
        if (this.kernelThread != null) {
            this.kernelThread.interrupt();
        }
    }

    public boolean getStart() {
        return this.started;
    }

    public boolean getPause() {
        return this.isPause();
    }

    @Override
    public void start() {
        if (!this.started) {
            this.checkData();
            this.executorService.execute(this.timerRunner);
            this.logger.info("\u8c03\u5ea6\u5668'" + this.name + "'\u542f\u52a8......");
            this.started = true;
            if (this.scheduleEngine != null) {
                this.scheduleEngine.setStatusStarted(this.id);
            }
        } else {
            throw new IllegalStateException("\u8c03\u5ea6\u5668\u5df2\u542f\u52a8\uff0c\u8c03\u7528\u72b6\u6001\u9519\u8bef\u3002id = " + this.id);
        }
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void restart() {
        if (this.started && !this.timerRunner.isPause()) {
            this.logger.warn("\u8c03\u5ea6\u5668\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u542f\u52a8\u64cd\u4f5c\u3002id = " + this.id);
            throw new IllegalStateException("\u8c03\u5ea6\u5668\u6b63\u5728\u6267\u884c\uff0c\u4e0d\u80fd\u91cd\u590d\u6267\u884c\u542f\u52a8\u64cd\u4f5c\u3002id = " + this.id);
        }
        this.logger.info("\u8c03\u5ea6\u5668'" + this.name + "'\u6682\u505c\u540e\uff0c\u88ab\u91cd\u65b0\u8fd0\u884c......");
        this.timerRunner.setPause(false);
        this.checkData();
        this.executorService.execute(this.timerRunner);
        if (this.scheduleEngine != null) {
            this.scheduleEngine.setStatusRestarted(this.id);
        }
        this.restartTime = System.currentTimeMillis();
    }

    private void checkData() {
        if (this.option == null) {
            throw new IllegalStateException("\u8c03\u5ea6\u5668'" + this.name + "'\u65e0\u6cd5\u542f\u52a8: option\u672a\u8bbe\u7f6e");
        }
    }

    @Override
    public void stop() {
        this.timerRunner.setStop();
        this.executorService.shutdown();
        this.started = false;
        if (this.scheduleEngine != null) {
            this.scheduleEngine.setStatusStoped(this.id);
        }
        this.logger.info("\u8c03\u5ea6\u5668'" + this.name + "'\u88ab\u7ec8\u6b62\u8fd0\u884c......");
    }

    @Override
    public void pause() {
        this.timerRunner.setPause(true);
        if (this.scheduleEngine != null) {
            this.scheduleEngine.setStatusPaused(this.id);
        }
        this.logger.info("\u8c03\u5ea6\u5668'" + this.name + "'\u6682\u505c......");
    }

    protected void setCurrentFailedTime(int currentFailedTime) {
        this.currentFailedTime = currentFailedTime;
    }

    public void setTimeInterval(long timeInterval) {
        this.timeInterval = timeInterval;
    }

    @Override
    public void setTaskTerminateCondition(boolean boo) {
        this.taskTerminateCondition = boo;
    }

    @Override
    public void setMaxFailedTimes(int maxFailedTimes) {
        this.maxFailedTimes = maxFailedTimes;
    }

    @Override
    public void setOption(Option option) {
        if (option == null) {
            throw new IllegalArgumentException("\u521b\u5efa\u8c03\u5ea6\u5668\u5931\u8d25\uff1a\u8bbe\u7f6e\u7684option\u5e76\u4e0d\u5b58\u5728");
        }
        this.option = option;
    }

    @Override
    public void setScheduleEngine(ScheduleEngine scheduleEngine) {
        this.scheduleEngine = scheduleEngine;
    }

    protected abstract Object runTask() throws Exception;

    protected void onBeforeSchedule(Option.TimeObject to) {
    }

    @Override
    public ArgumentsManager getArgumentManager() {
        return this.argumentManager;
    }

    @Override
    public void setArgumentManager(ArgumentsManager argumentManager) {
        this.argumentManager = argumentManager;
    }

    private class InternalTimerRunner
    implements Runnable {
        private boolean pause = false;
        private boolean stop = false;

        private InternalTimerRunner() {
        }

        public void setStop() {
            this.stop = true;
        }

        public void setPause(boolean pause) {
            this.pause = pause;
        }

        public boolean isPause() {
            return this.pause;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                if (AbstractScheduler.this.maxFailedTimes >= 1 && AbstractScheduler.this.currentFailedTime >= AbstractScheduler.this.maxFailedTimes) {
                    AbstractScheduler.this.logger.info("\u8c03\u5ea6\u88ab\u8feb\u7ec8\u6b62'" + AbstractScheduler.this.name + "': \u56e0\u4e3a\u8c03\u7528\u5931\u8d25\u8d85\u8fc7\u6700\u5927\u503c(" + AbstractScheduler.this.maxFailedTimes + ")");
                    break;
                }
                if (this.pause) break;
                try {
                    Option.TimeObject to = AbstractScheduler.this.option.isAvailableTime(System.currentTimeMillis());
                    if (!to.isAvailable()) continue;
                    AbstractScheduler.this.logger.debug("======== \u6ee1\u8db3\u65f6\u95f4\u8981\u6c42\uff0c\u6267\u884c\u4efb\u52a1\u8c03\u7528\u4e00\u6b21");
                    AbstractScheduler.this.onBeforeSchedule(to);
                    Object result = AbstractScheduler.this.runTask();
                    if (AbstractScheduler.this.option.isCycleTask()) {
                        AbstractScheduler.this.option.scheduleToNext(to);
                    }
                    if (result != null || !AbstractScheduler.this.taskTerminateCondition) continue;
                    AbstractScheduler.this.logger.info("\u8c03\u5ea6\u88ab\u8feb\u7ec8\u6b62'" + AbstractScheduler.this.name + "': \u56e0\u4e3a\u8c03\u7528\u672a\u8fd4\u56de\u4efb\u4f55\u6570\u636e");
                    break;
                }
                catch (Exception ex) {
                    if (ex instanceof NotFoundGatherDataException) {
                        AbstractScheduler.this.logger.debug("\u6570\u636e\u6e90\u6ca1\u6709\u53ef\u91c7\u96c6\u6570\u636e\uff0c\u4e0d\u5c5e\u4e8e\u4e1a\u52a1\u9519\u8bef\u3002");
                        continue;
                    }
                    if (AbstractScheduler.this.currentFailedTime >= Integer.MAX_VALUE) {
                        AbstractScheduler.this.currentFailedTime = 0;
                    }
                    ++AbstractScheduler.this.currentFailedTime;
                    AbstractScheduler.this.logger.error("\u4efb\u52a1\u8c03\u7528\u5931\u8d25\u4e00\u6b21\uff0cscheduler = " + AbstractScheduler.this.id, (Throwable)ex);
                }
                finally {
                    try {
                        if (AbstractScheduler.this.timeInterval <= 0L) continue;
                        TimeUnit.MILLISECONDS.sleep(AbstractScheduler.this.timeInterval);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (!this.pause && !this.stop) {
                if (AbstractScheduler.this.scheduleEngine != null) {
                    AbstractScheduler.this.scheduleEngine.setStatusDone(AbstractScheduler.this.id);
                }
                AbstractScheduler.this.started = false;
            }
        }
    }
}

