/*
 * Decompiled with CFR 0.152.
 */
package com.walker.scheduler;

import com.walker.scheduler.AbstractScheduler;
import com.walker.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GatherSchedulerManager {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentHashMap<Integer, AbstractScheduler> cached = new ConcurrentHashMap(8);

    protected ConcurrentHashMap<Integer, AbstractScheduler> getCachedData() {
        return this.cached;
    }

    public void startScheduler(AbstractScheduler gatherScheduler) {
        if (gatherScheduler == null) {
            return;
        }
        if (this.cached.get(gatherScheduler.getId()) != null) {
            throw new IllegalStateException("\u5df2\u7ecf\u5b58\u5728\u8c03\u5ea6\u5668\u5b9e\u73b0\uff0c\u4e0d\u80fd\u91cd\u590d\u3002id = " + gatherScheduler.getId());
        }
        this.cached.putIfAbsent(gatherScheduler.getId(), gatherScheduler);
        gatherScheduler.start();
        this.logger.info("[GatherSchedulerManager]-\u542f\u52a8\u4e86\u4e00\u4e2a\u8c03\u5ea6\u5668\uff1a" + gatherScheduler);
    }

    @Deprecated
    public void restartScheduler(AbstractScheduler gatherScheduler) {
        if (gatherScheduler == null) {
            return;
        }
        Scheduler gs = this.cached.get(gatherScheduler.getId());
        if (gs != null) {
            gs.restart();
            this.logger.debug("\u7f13\u5b58\u4e2d\u5b58\u5728\u8be5\u8c03\u5ea6\u5668\uff0c\u91cd\u65b0\u542f\u52a8\u3002id = " + gs.getId());
            return;
        }
        this.cached.putIfAbsent(gatherScheduler.getId(), gatherScheduler);
        gatherScheduler.restart();
        this.logger.info("[GatherSchedulerManager]-\u91cd\u65b0\u542f\u52a8\u8be5\u8c03\u5ea6\u5668\uff1a" + gatherScheduler);
    }

    public void restartScheduler(int id) {
        Scheduler gs = this.cached.get(id);
        if (gs != null) {
            gs.restart();
            this.logger.debug("\u7f13\u5b58\u4e2d\u5b58\u5728\u8be5\u8c03\u5ea6\u5668\uff0c\u91cd\u65b0\u542f\u52a8\u3002id = " + gs.getId());
            return;
        }
    }

    public void stopScheduler(int schedulerId) {
        Scheduler scheduler = this.cached.get(schedulerId);
        if (scheduler == null) {
            throw new IllegalStateException("GatherSchedulerManager\u7ba1\u7406\u5668\u4e2d\u5c1a\u672a\u5b58\u5728\u8be5\u8c03\u5ea6\u5668\uff1a" + schedulerId);
        }
        try {
            scheduler.stop();
            this.cached.remove(schedulerId);
        }
        catch (Exception ex) {
            this.logger.error("\u505c\u6b62\u8c03\u5ea6\u5668\u51fa\u73b0\u5f02\u5e38\uff1a" + ex.getMessage(), (Throwable)ex);
        }
    }

    public void pauseScheduler(int schedulerId) {
        Scheduler scheduler = this.cached.get(schedulerId);
        if (scheduler == null) {
            throw new IllegalStateException("GatherSchedulerManager\u7ba1\u7406\u5668\u4e2d\u5c1a\u672a\u5b58\u5728\u8be5\u8c03\u5ea6\u5668\uff1a" + schedulerId);
        }
        scheduler.pause();
    }

    public List<AbstractScheduler> listSchedulers() {
        ArrayList<AbstractScheduler> result = new ArrayList<AbstractScheduler>(this.cached.size());
        for (AbstractScheduler gs : this.cached.values()) {
            result.add(gs);
        }
        return result;
    }

    public AbstractScheduler getOneGatherScheduler(int schedulerId) {
        AbstractScheduler scheduler = this.cached.get(schedulerId);
        return scheduler;
    }

    protected abstract void initialize();
}

