/*
 * Decompiled with CFR 0.152.
 */
package com.walker.scheduler;

import com.walker.infrastructure.utils.DateUtils;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Option {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final DateFormat whippletreeTimeFormat = new SimpleDateFormat("yyyy MM dd HH mm");
    private PeriodType periodType = PeriodType.NONE;
    private TimeType timeType = TimeType.EXACTLY;
    private int hour = 0;
    private int day = 1;
    private int month = 1;
    private int year = 2015;
    private List<Integer[]> timeRanges = new ArrayList<Integer[]>(2);
    private boolean isCycleTask = true;
    private int currentTaskDay = 0;
    private int currentTaskMonth = 0;
    private int currentTaskYear = 0;

    public boolean isCycleTask() {
        return this.isCycleTask;
    }

    public int getCurrentTaskDay() {
        return this.currentTaskDay;
    }

    public int getCurrentTaskMonth() {
        return this.currentTaskMonth;
    }

    public int getCurrentTaskYear() {
        return this.currentTaskYear;
    }

    public String getTimeRangesValue() {
        StringBuilder s = new StringBuilder();
        for (Integer[] vals : this.timeRanges) {
            s.append(vals[0]);
            s.append(",");
            s.append(vals[1]);
        }
        return s.toString();
    }

    public TimeType getTimeType() {
        return this.timeType;
    }

    public PeriodType getPeriodType() {
        return this.periodType;
    }

    public void setTimeType(TimeType timeType) {
        this.timeType = timeType;
    }

    public void setPeriodType(PeriodType periodType) {
        this.periodType = periodType;
        this.isCycleTask = periodType == PeriodType.DAY || periodType == PeriodType.WEEK || periodType == PeriodType.MONTH || periodType == PeriodType.YEAR || periodType == PeriodType.NONE;
    }

    public void setExactlyTime(int year, int month, int day, int hour) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.currentTaskYear = year;
        this.currentTaskMonth = month;
        this.currentTaskDay = day;
        if (this.isCycleTask) {
            TimeObject timeObj = this.isAvailableTime(System.currentTimeMillis());
            int currentHour = DateUtils.getCurrentHour();
            int currentDay = DateUtils.getCurrentYearMonthDay()[2];
            if (this.periodType == PeriodType.DAY) {
                if (currentHour > hour) {
                    this.scheduleToNext(timeObj);
                    this.logger.info("\u4eca\u5929\u5df2\u7ecf\u8fc7\u4e86\u65f6\u95f4\u70b9\uff0c\u81ea\u52a8\u5207\u6362\u5230\u4e0b\u4e00\u6b21\uff0coption={}", (Object)this);
                }
            } else if (this.periodType == PeriodType.MONTH) {
                if (currentDay > day) {
                    this.scheduleToNext(timeObj);
                    this.logger.info("\u672c\u6708\u5f53\u524d\u65e5\u671f{}\u5df2\u8d85\u8fc7\u8bbe\u7f6e\u65e5\u671f{}\uff0c\u81ea\u52a8\u5207\u6362\u5230\u4e0b\u4e00\u6b21\uff0coption={}", new Object[]{currentDay, day, this});
                } else if (currentDay == day && currentHour > hour) {
                    this.scheduleToNext(timeObj);
                    this.logger.info("\u672c\u6708\u65e5\u671f\u5df2\u5230\u8fbe\uff0c\u4f46\u7531\u4e8e\u65f6\u95f4\u5df2\u8fc7\u671f\uff0c\u56e0\u6b64\u4efb\u52a1\u4f1a\u5728\u4e0b\u4e2a\u6708\u6267\u884c\uff0coption={}", (Object)this);
                }
            } else if (this.periodType == PeriodType.YEAR) {
                int currentMonth = DateUtils.getCurrentYearMonthDay()[1];
                if (currentMonth > month) {
                    this.scheduleToNext(timeObj);
                    this.logger.info("\u672c\u5e74\u5f53\u524d\u6708\u4efd{}\u5df2\u8d85\u8fc7\u8bbe\u7f6e\u6708\u4efd{}\uff0c\u81ea\u52a8\u5207\u6362\u5230\u4e0b\u4e00\u6b21\uff0coption={}", new Object[]{currentMonth, month, this});
                } else if (currentMonth == month && currentDay > day) {
                    this.scheduleToNext(timeObj);
                    this.logger.info("\u672c\u5e74\u5f53\u524d\u6708\u4efd\u76f8\u540c\uff0c\u4f46\u5f53\u524d\u65e5\u671f{}\u5df2\u8d85\u8fc7\u8bbe\u7f6e\u65e5\u671f{}\uff0c\u81ea\u52a8\u5207\u6362\u5230\u4e0b\u4e00\u6b21\uff0coption={}", new Object[]{currentDay, day, this});
                } else if (currentMonth == month && currentDay == day && currentHour > hour) {
                    this.scheduleToNext(timeObj);
                    this.logger.info("\u672c\u5e74\u5f53\u524d\u6708\u4efd\u65e5\u671f\u76f8\u540c\uff0c\u4f46\u5f53\u524d\u65f6\u95f4{}\u5df2\u8d85\u8fc7\u8bbe\u7f6e\u65f6\u95f4{}\uff0c\u81ea\u52a8\u5207\u6362\u5230\u4e0b\u4e00\u6b21\uff0coption={}", new Object[]{currentHour, hour, this});
                }
            }
        }
    }

    public void setRangeTime(List<Integer[]> timeRanges) {
        if (timeRanges == null || timeRanges.size() == 0) {
            throw new IllegalArgumentException("\u8bbe\u7f6e\u7684\u65f6\u95f4\u8303\u56f4\u6570\u636e\u5fc5\u987b\u5b58\u5728");
        }
        for (Integer[] r : timeRanges) {
            if (r.length == 2) continue;
            throw new IllegalArgumentException("\u8bbe\u7f6e\u65f6\u95f4\u8303\u56f4\u96c6\u5408\u4e2d\uff0c\u6bcf\u4e2a\u6570\u7ec4\u8868\u793a\u4e00\u4e2a\u8303\u56f4\uff1a\u5f00\u59cb\u949f\u70b9\u3001\u7ed3\u675f\u949f\u70b9\u3002\u5982\uff1a12~13");
        }
        this.timeRanges = timeRanges;
    }

    public TimeObject isAvailableTime(long currentTime) {
        return this.doCheckAvailable(currentTime);
    }

    public boolean isAvailable(long currentTime) {
        return this.doCheckAvailable(currentTime).isAvailable();
    }

    public void scheduleToNext(TimeObject currentTimeObj) {
        if (this.isCycleTask) {
            if (this.periodType == PeriodType.DAY || this.periodType == PeriodType.NONE) {
                int[] nextDateInfo = DateUtils.getNextDay((int)currentTimeObj.getYear(), (int)currentTimeObj.getMonth(), (int)currentTimeObj.getDay(), (int)1);
                this.currentTaskYear = nextDateInfo[0];
                this.currentTaskMonth = nextDateInfo[1];
                this.currentTaskDay = nextDateInfo[2];
            } else if (this.periodType == PeriodType.MONTH) {
                this.currentTaskYear = currentTimeObj.year;
                this.currentTaskMonth = this.currentTaskMonth < 12 ? ++this.currentTaskMonth : 1;
            } else if (this.periodType == PeriodType.YEAR) {
                ++this.currentTaskYear;
            } else {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TimeObject doCheckAvailable(long currentTime) {
        TimeObject timeObj = this.getTimeInfo(currentTime);
        boolean result = false;
        if (this.isCycleTask) {
            if (this.periodType == PeriodType.DAY) {
                if (this.currentTaskDay == timeObj.day && this.hour == timeObj.hour) {
                    result = true;
                }
            } else {
                if (this.periodType == PeriodType.WEEK) {
                    throw new UnsupportedOperationException("\u8fd8\u672a\u5b9e\u73b0\u6309\u5468\u8c03\u5ea6");
                }
                if (this.periodType == PeriodType.MONTH) {
                    if (this.currentTaskMonth == timeObj.month && this.day == timeObj.day && this.hour == timeObj.hour) {
                        result = true;
                    }
                } else if (this.periodType == PeriodType.YEAR) {
                    if (this.currentTaskYear == timeObj.year && this.month == timeObj.month && this.day == timeObj.day && this.hour == timeObj.hour) {
                        result = true;
                    }
                } else {
                    if (this.periodType != PeriodType.NONE) throw new UnsupportedOperationException();
                    if (this.year == timeObj.year && this.month == timeObj.month && this.day == timeObj.day && this.hour == timeObj.hour) {
                        result = true;
                    }
                }
            }
        } else {
            result = this.doAnalizeHourMatch(timeObj);
        }
        timeObj.setAvailable(result);
        return timeObj;
    }

    private boolean doAnalizeHourMatch(TimeObject timeObj) {
        if (this.timeType == TimeType.EXACTLY) {
            if (timeObj.getHour() >= this.hour) {
                this.logger.debug("\u8d85\u8fc7\u8bbe\u5b9a\u65f6\u95f4\uff0c\u6267\u884c\u4efb\u52a1");
                return true;
            }
        } else {
            for (Integer[] r : this.timeRanges) {
                if (timeObj.getHour() < r[0] || timeObj.getHour() > r[1]) continue;
                this.logger.debug("------\u5339\u914d\u4e86\u65f6\u95f4\u6bb5\uff1a" + r[0]);
                return true;
            }
        }
        return false;
    }

    private TimeObject getTimeInfo(long currentTime) {
        String showDate = whippletreeTimeFormat.format(new Date(currentTime));
        String[] showDateArray = showDate.split(" ");
        TimeObject timeObj = new TimeObject(Integer.parseInt(showDateArray[0]), Integer.parseInt(showDateArray[1]), Integer.parseInt(showDateArray[2]), Integer.parseInt(showDateArray[3]));
        return timeObj;
    }

    public String toString() {
        return "[periodType=" + (Object)((Object)this.periodType) + ", timeType=" + (Object)((Object)this.timeType) + ", timeRanges=" + this.timeRanges + ", isCycleTask=" + this.isCycleTask + ", setYearMonthDayHour=" + this.year + "-" + this.month + "-" + this.day + "-" + this.hour + ", nextTime=" + this.currentTaskYear + "-" + this.currentTaskMonth + "-" + this.currentTaskDay + "]";
    }

    public static void main(String[] args) {
        Option.testCycleDay();
        Option.testCycleMonth();
    }

    private static void testCycleDay() {
        Option option = new Option();
        option.setPeriodType(PeriodType.DAY);
        option.setTimeType(TimeType.EXACTLY);
        option.setExactlyTime(2023, 12, 31, 11);
        TimeObject timeObj = option.isAvailableTime(System.currentTimeMillis());
        System.out.println("\u7b2c\u4e00\u6b21\u8c03\u7528\u7ed3\u679c\uff1a" + timeObj.isAvailable());
        option.scheduleToNext(timeObj);
        System.out.println("\u5207\u6362\u540e\uff0c\u8c03\u7528\u7ed3\u679c\uff1a" + option.isAvailable(System.currentTimeMillis()));
        System.out.println(option.currentTaskYear + "\u5e74" + option.currentTaskMonth + "\u6708" + option.currentTaskDay + "\u65e5");
    }

    private static void testCycleMonth() {
        Option option = new Option();
        option.setPeriodType(PeriodType.MONTH);
        option.setExactlyTime(2019, 1, 2, 16);
        TimeObject timeObj = option.isAvailableTime(System.currentTimeMillis());
        System.out.println("\u7b2c\u4e00\u6b21\u8c03\u7528\u7ed3\u679c\uff1a" + timeObj.isAvailable());
        option.scheduleToNext(timeObj);
        System.out.println("\u5207\u6362\u540e\uff0c\u8c03\u7528\u7ed3\u679c\uff1a" + option.isAvailable(System.currentTimeMillis()));
        System.out.println(option.currentTaskMonth);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum PeriodType {
        NONE{

            @Override
            public String getIndex() {
                return PeriodType.PERIOD_TYPE_ONCE;
            }
        }
        ,
        DAY{

            @Override
            public String getIndex() {
                return PeriodType.PERIOD_TYPE_CYCLE_DAY;
            }
        }
        ,
        WEEK{

            @Override
            public String getIndex() {
                return PeriodType.PERIOD_TYPE_CYCLE_WEEK;
            }
        }
        ,
        MONTH{

            @Override
            public String getIndex() {
                return PeriodType.PERIOD_TYPE_CYCLE_MONTH;
            }
        }
        ,
        YEAR{

            @Override
            public String getIndex() {
                return PeriodType.PERIOD_TYPE_CYCLE_YEAR;
            }
        }
        ,
        FOREVER{

            @Override
            public String getIndex() {
                return PeriodType.PERIOD_TYPE_FOREVER;
            }
        };

        public static final String PERIOD_TYPE_ONCE = "none";
        public static final String PERIOD_TYPE_CYCLE_DAY = "day";
        public static final String PERIOD_TYPE_CYCLE_WEEK = "week";
        public static final String PERIOD_TYPE_CYCLE_MONTH = "month";
        public static final String PERIOD_TYPE_CYCLE_YEAR = "year";
        public static final String PERIOD_TYPE_FOREVER = "forever";

        public String getIndex() {
            throw new AbstractMethodError();
        }

        public static PeriodType getObject(String index) {
            if (index.equals(PERIOD_TYPE_ONCE)) {
                return NONE;
            }
            if (index.equals(PERIOD_TYPE_CYCLE_DAY)) {
                return DAY;
            }
            if (index.equals(PERIOD_TYPE_CYCLE_WEEK)) {
                return WEEK;
            }
            if (index.equals(PERIOD_TYPE_CYCLE_MONTH)) {
                return MONTH;
            }
            if (index.equals(PERIOD_TYPE_CYCLE_YEAR)) {
                return YEAR;
            }
            if (index.equals(PERIOD_TYPE_FOREVER)) {
                return FOREVER;
            }
            throw new IllegalArgumentException();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TimeType {
        EXACTLY{

            @Override
            public String getIndex() {
                return "exactly";
            }
        }
        ,
        RANGE{

            @Override
            public String getIndex() {
                return "ranges";
            }
        };


        public String getIndex() {
            throw new AbstractMethodError();
        }

        public static TimeType getObject(String index) {
            if (index.equals("exactly")) {
                return EXACTLY;
            }
            return RANGE;
        }
    }

    public class TimeObject {
        private int year = 2015;
        private int month = 1;
        private int day = 1;
        private int hour = 1;
        private boolean available = false;

        public boolean isAvailable() {
            return this.available;
        }

        public void setAvailable(boolean available) {
            this.available = available;
        }

        public int getYear() {
            return this.year;
        }

        public int getMonth() {
            return this.month;
        }

        public int getDay() {
            return this.day;
        }

        public int getHour() {
            return this.hour;
        }

        public TimeObject(int year, int month, int day, int hour) {
            this.year = year;
            this.month = month;
            this.day = day;
            this.hour = hour;
        }

        public String toString() {
            return "[year=" + this.year + ", month=" + this.month + ", day=" + this.day + ", hour=" + this.hour + "]";
        }

        public boolean isSameDay(int year, int month, int day) {
            return this.year == year && this.month == month && this.day == day;
        }

        public boolean isSameDay(int month, int day) {
            return this.month == month && this.day == day;
        }

        public boolean isSameDay(int day) {
            return this.day == day;
        }
    }
}

