/*
 * Decompiled with CFR 0.152.
 */
package com.walker.security;

import com.walker.security.LocalSpider;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class DefaultLocalSpider
implements LocalSpider {
    private static final String host = "*.*.*.*";
    private List<String> identifiers = null;

    @Override
    public String getMyIdentifier() {
        List<String> values = this.getMacAddresses();
        if (values == null || values.size() == 0) {
            throw new Error("not found spider my identifier!");
        }
        return values.get(0);
    }

    @Override
    public List<String> getMyIdentifiers() {
        return this.doGetMyIdentifiers();
    }

    private List<String> doGetMyIdentifiers() {
        if (this.identifiers == null) {
            this.identifiers = this.getMacAddresses();
        }
        if (this.identifiers == null || this.identifiers.equals("")) {
            throw new IllegalArgumentException();
        }
        return this.identifiers;
    }

    private List<String> getMacAddresses() {
        ArrayList<String> addresses = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        try {
            Enumeration<NetworkInterface> el = NetworkInterface.getNetworkInterfaces();
            NetworkInterface ni = null;
            while (el.hasMoreElements()) {
                byte[] mac;
                ni = el.nextElement();
                if (ni.isLoopback() || ni.isVirtual() || !ni.isUp() || (mac = ni.getHardwareAddress()) == null || mac.length == 0) continue;
                sb.delete(0, sb.length());
                String hexString = null;
                for (byte b : mac) {
                    hexString = Integer.toHexString(b & 0xFF);
                    sb.append((String)(hexString.length() == 1 ? "0" + hexString : hexString));
                }
                addresses.add(sb.toString());
            }
            System.out.println(addresses);
        }
        catch (SocketException e1) {
            e1.printStackTrace();
            throw new Error();
        }
        return addresses;
    }

    String getMacAddress() {
        Object mac = "";
        StringBuffer sb = new StringBuffer();
        try {
            NetworkInterface el = NetworkInterface.getByInetAddress(InetAddress.getByName(host));
            byte[] macs = el.getHardwareAddress();
            for (int i = 0; i < macs.length; ++i) {
                mac = Integer.toHexString(macs[i] & 0xFF);
                if (((String)mac).length() == 1) {
                    mac = "0" + (String)mac;
                }
                sb.append((String)mac + "-");
            }
        }
        catch (SocketException e1) {
            e1.printStackTrace();
            throw new Error();
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
            throw new Error();
        }
        mac = sb.toString();
        mac = ((String)mac).substring(0, ((String)mac).length() - 1);
        return mac;
    }
}

