/*
 * Decompiled with CFR 0.152.
 */
package com.walker.security;

import com.walker.security.DefaultLocalSpider;
import com.walker.security.DefaultSpiderLoader;
import com.walker.security.LocalSpider;
import com.walker.security.RSAUtils;
import com.walker.security.SecurityRuntimeException;
import com.walker.security.SpiderLoader;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SystemLogMan {
    private static final SpiderLoader loader = new DefaultSpiderLoader();
    private static final Man man = new Man();
    private static final SystemLogMan slm = new SystemLogMan();
    private static final String LOCALHOST_1 = "127.0.0.1";
    private static final String LOCALHOST_2 = "localhost";

    private SystemLogMan() {
    }

    public static final SystemLogMan getInstance() {
        return slm;
    }

    public final void checkMan(String host) {
        if (host != null && (host.indexOf(LOCALHOST_1) >= 0 || host.indexOf(LOCALHOST_2) >= 0)) {
            return;
        }
        this.doManCheck();
    }

    @Deprecated
    public final void checkMan() {
    }

    private final void doCheckMan2() {
        man.checkMan();
    }

    private final void doManCheck() {
        int status;
        Object[] result;
        if (SystemLogMan.man.manStatus) {
            // empty if block
        }
        if ((result = (Object[])loader.load()) == null || result.length != 2) {
            SystemLogMan.man.manStatus = false;
            man.getEating();
        }
        if ((status = ((Integer)result[0]).intValue()) == 1) {
            man.setMan((byte[])result[1]);
            if (!SystemLogMan.man.manStatus) {
                man.getEating();
            }
        } else {
            System.out.println("-------- load sysLogMan failed!");
            man.getEating();
        }
    }

    private static class Man {
        private boolean manStatus = false;
        private LocalSpider spider = new DefaultLocalSpider();
        private int type = 0;
        private String address;
        private long st = 0L;
        private long et = 0L;

        private Man() {
        }

        public void setMan(byte[] content) {
            this.doCheckMan(content);
        }

        private void doCheckMan(byte[] content) {
            byte temp;
            if (content == null || content.length <= 0) {
                return;
            }
            int size = content.length;
            ByteBuffer messageBuffer = ByteBuffer.allocate(1024);
            ByteBuffer buffer = ByteBuffer.wrap(content);
            for (int i = 0; i < size && (char)(temp = buffer.get()) != '\n'; ++i) {
                messageBuffer.put(temp);
            }
            messageBuffer.flip();
            byte[] message = new byte[messageBuffer.remaining()];
            messageBuffer.get(message);
            this.display("\u6d88\u606f\u4f53", message);
            byte[] publicKeys = new byte[buffer.remaining()];
            buffer.get(publicKeys);
            this.display("pk", publicKeys);
            try {
                byte[] addressBytes = RSAUtils.decryptByPublicKey(message, new String(publicKeys));
                String source = this.spider.getMyIdentifier();
                String now = new String(addressBytes);
                if (source != null && now != null && source.equals(now)) {
                    this.manStatus = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }

        private void getEating() {
            try {
                TimeUnit.SECONDS.sleep(3L);
                System.out.println("------> my walker ea logging...");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        private void display(String msg, byte[] bytes) {
        }

        public void setMan(String[] array) {
            this.doSetMan(array);
        }

        private void doSetMan(String[] array) {
            if (array == null || array.length != 4) {
                throw new IllegalArgumentException();
            }
            this.type = Integer.parseInt(array[0].toString());
            this.address = array[1];
            this.st = Long.parseLong(array[2]);
            this.et = Long.parseLong(array[3]);
            this.manStatus = true;
        }

        @Deprecated
        public void checkMan() {
        }

        private void doCheckLisence() {
            if (!this.manStatus) {
                Object[] result = (Object[])loader.load();
                if (result == null || result.length != 2) {
                    throw new SecurityRuntimeException();
                }
                if (!result[0].toString().equals("1")) {
                    throw new SecurityRuntimeException();
                }
                this.setMan((String[])result[1]);
            }
            if (this.type == 0) {
                this.doValidateAddress();
            } else if (this.type == 1) {
                this.doValidateDate();
            } else if (this.type == 2) {
                this.doValidateAddress();
                this.doValidateDate();
            } else {
                throw new SecurityRuntimeException("unknown authen type: " + this.type, null);
            }
        }

        private boolean doValidateAddress() {
            List<String> addresses = this.spider.getMyIdentifiers();
            if (addresses != null && addresses.contains(this.address)) {
                return true;
            }
            throw new SecurityRuntimeException("address error:", null);
        }

        private boolean doValidateDate() {
            long _cuTime = System.currentTimeMillis();
            if (_cuTime > this.st && _cuTime < this.et) {
                return true;
            }
            throw new SecurityRuntimeException("date expired:", null);
        }
    }
}

