package com.walker.security;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class DefaultLocalSpider implements LocalSpider {

	private static final String host = "*.*.*.*";
	private List<String> identifiers = null;
	
//	@Override
	public String getMyIdentifier() {
		List<String> values = getMacAddresses();
		if(values == null || values.size() == 0){
			throw new Error("not found spider my identifier!");
		}
		return values.get(0);
	}

//	@Override
	public List<String> getMyIdentifiers() {
		return doGetMyIdentifiers();
	}
	
	private List<String> doGetMyIdentifiers(){
		if(this.identifiers == null){
			identifiers = getMacAddresses();
		}
		if(identifiers == null || identifiers.equals(""))
			throw new IllegalArgumentException();
		return identifiers;
	}

//	private List<String> getIpAddresses(){
//		Enumeration<NetworkInterface> el;
//        List<String> addresses = new ArrayList<String>();
//        StringBuilder sb = new StringBuilder();
//        try {
//            el = NetworkInterface.getNetworkInterfaces();
//            NetworkInterface ni = null;
//            while (el.hasMoreElements()) {
//            	ni = el.nextElement();
////            	if(ni.isLoopback()) continue;
//            	if(ni.isVirtual()) continue;
//            	if(!ni.isUp()) continue;
////            	System.out.println("---- 网卡: " + ni.getDisplayName() + ", isLive: " + ni.isUp() + ", isVirtual = " + ni.isVirtual() + ", isLoop = " + ni.isLoopback());
//            	byte[] mac = ni.getHardwareAddress();
//                if(mac != null && mac.length != 0){
//                	sb.delete(0, sb.length());
//                	String hexString = null;
//                	for(byte b : mac){
//                		hexString = Integer.toHexString(b & 0xFF);
//                		sb.append((hexString.length() == 1) ? "0" + hexString : hexString);
//                	}
//                	addresses.add(sb.toString());
//                }
//            }
//            System.out.println(addresses);
//
//        } catch (SocketException e1) {
//            e1.printStackTrace();
//            throw new Error();
//        }
//        return addresses;
//	}
	
	/**
	 * 返回可用的网卡Mac地址集合
	 * @return
	 */
	private List<String> getMacAddresses(){
		Enumeration<NetworkInterface> el;
        List<String> addresses = new ArrayList<String>();
        StringBuffer sb = new StringBuffer();
        try {
            el = NetworkInterface.getNetworkInterfaces();
            NetworkInterface ni = null;
            while (el.hasMoreElements()) {
            	ni = el.nextElement();
            	if(ni.isLoopback()) continue;
            	if(ni.isVirtual()) continue;
            	if(!ni.isUp()) continue;
//            	System.out.println("---- 网卡: " + ni.getDisplayName() + ", isLive: " + ni.isUp() + ", isVirtual = " + ni.isVirtual() + ", isLoop = " + ni.isLoopback());
                byte[] mac = ni.getHardwareAddress();
                if(mac != null && mac.length != 0){
                	sb.delete(0, sb.length());
                	String hexString = null;
                	for(byte b : mac){
                		hexString = Integer.toHexString(b & 0xFF);
                		sb.append((hexString.length() == 1) ? "0" + hexString : hexString);
                	}
                	addresses.add(sb.toString());
                }
            }
            System.out.println(addresses);

        } catch (SocketException e1) {
            e1.printStackTrace();
            throw new Error();
        }
        return addresses;
	}
	
	String getMacAddress(){
		String mac = "";  
	    StringBuffer sb = new StringBuffer();
		try {
			NetworkInterface el = NetworkInterface.getByInetAddress(InetAddress.getByName(host));
            byte[] macs = el.getHardwareAddress();
            for(int i=0; i<macs.length; i++)  {  
            	mac = Integer.toHexString(macs[i] & 0xFF);   
	            if(mac.length() == 1){   
	            	mac = '0' + mac;   
	            }   
                sb.append(mac + "-");
            } 
        } catch (SocketException e1) {
            e1.printStackTrace();
            throw new Error();
        } catch(UnknownHostException ex){
        	ex.printStackTrace();
        	throw new Error();
        }
		mac = sb.toString();  
        mac = mac.substring(0, mac.length()-1);  
        return mac;
	}
	
//	private String hexByte(byte b) {
//		String s = "000000" + Integer.toHexString(b);
//		return s.substring(s.length() - 2);
//	}
	
//	public static void main(String[] args){
//		LocalSpider spider = new DefaultLocalSpider();
//		spider.getMyIdentifier();
//	}
}
