package com.walker.security;

import com.walker.security.util.ClassPathResource;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DefaultSpiderLoader implements SpiderLoader {

	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	// update code 
	//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	private GenerateCoder generateCoder = new GenerateCoder();
	
	// 未用到的变量，可以删除
	String[] lisence = null;
		
//	@Override
	public Object load() {
		return doLoad();
	}
	
	private Object[] doLoad(){
		Object[] result = new Object[2];
		InputStream inputStream = getFile();
		if(inputStream == null){
			result[0] = STATE_FAILED;
			return result;
		}
		BufferedInputStream bis = new BufferedInputStream(inputStream);
		try{
			int size = bis.available();
			byte[] contentBytes = new byte[size];
			bis.read(contentBytes);
			
//			String content = new String(contentBytes);
//			System.out.println(content);
			result[0] = STATE_OK;
			result[1] = contentBytes;
			
			// 真正的处理逻辑
			return generateCoder.readLisenceFile();
			
		} catch(IOException ex){
//			throw new SecurityRuntimeException("read file error: ", ex);
			ex.printStackTrace();
			result[0] = STATE_FAILED;
			return result;
		} finally {
			if(inputStream != null){
				try {
					inputStream.close();
				} catch (IOException e) {}
			}
		}
	}

	private InputStream getFile(){
//		InputStream input = this.getClass().getResourceAsStream("/resource/walker_sn_walkersoft.bin");
//		/resources/wk_sn_lic.bin
//		InputStream input = this.getClass().getResourceAsStream("wk_sn_lic.bin");
//		System.out.println("get file = " + input);
//		return input;

//		ClassPathResource file = new ClassPathResource("com.walker.security.my_walker_log.bin");
		ClassPathResource file = new ClassPathResource("wk_sn_lic.bin");
		if(file.exists()){
			try {
				return file.getInputStream();
			} catch (IOException e) {
				throw new SecurityRuntimeException("wk_sn_lic.bin not found!");
			}
		}
		return null;
	}
	
	private static final int STATE_OK = 1;
	private static final int STATE_FAILED = 0;
	
	private class GenerateCoder{
		private String pk = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCL4fwI6s3zdK0RIDQ0o9xQ7Lq4CoETtOKbDRSCwdCeQ5PrWys4tlenCGOds5SAkOrXFt7wOt0Z33PlAMXpLxAq1gDp/vlOLPPxTfm7S6mUhGNrYOv/0FXQ3rWa7G/UZaXlybn7WLcr2yFaJbwSxxKWa/WuNc1wyCii1S854ZvGBQIDAQAB";
		/**
		 * 返回读取的协议文件内容。
		 * @return 数组：[0]=状态码，[1]=属性集合string[]
		 */
		public Object[] readLisenceFile(){
			Object[] result = new Object[2];
			InputStream inputStream = getFile();
			BufferedInputStream bis = new BufferedInputStream(inputStream);
			try{
				int size = bis.available();
				byte[] contentBytes = new byte[size];
				bis.read(contentBytes);
				
				// 解密文件字节内容
				byte[] fileContent = RSAUtils.decryptByPublicKey(contentBytes, pk);
				String content = new String(fileContent);
//				System.out.println(content);
				if(content == null || content.equals("")){
					throw new IllegalArgumentException("not found lisence content!");
				}
				
				String[] props = content.split("\r\n");
				result[0] = STATE_OK;
				result[1] = props;
				lisence = props;
				return result;
				
			} catch(Exception ex){
//				throw new SecurityRuntimeException("read file error: ", ex);
				ex.printStackTrace();
				result[0] = STATE_FAILED;
				return result;
			} finally {
				if(inputStream != null){
					try {
						inputStream.close();
					} catch (IOException e) {}
				}
			}
		}
	}
	
//	public static void main(String[] args){
//		SpiderLoader loader = new DefaultSpiderLoader();
//		Object result = loader.load();
//		Object[] rs = (Object[])result;
//		if(rs != null){
//			System.out.println("status: " + rs[0]);
//			String[] props = (String[])rs[1];
//			if(props != null){
//				for(String s : props){
//					System.out.println(s);
//				}
//			}
//		}
//	}
}
