package com.walker.security;

//import org.slf4j.Logger;
//import org.slf4j.LoggerFactory;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class SystemLogMan {
	
//	private final transient Logger logger = LoggerFactory.getLogger(getClass());
	
	private static final SpiderLoader loader = new DefaultSpiderLoader();
	
	private static final Man man = new Man();
	
	private static final SystemLogMan slm = new SystemLogMan();
	
	private static final String LOCALHOST_1 = "127.0.0.1";
	private static final String LOCALHOST_2 = "localhost";
	
	
	private SystemLogMan(){}
	
	public static final SystemLogMan getInstance(){
		return slm;
	}
	
	public final void checkMan(String host){
		// 如果是开发环境，本地测试，不再检查注册
		if(host != null && (host.indexOf(LOCALHOST_1) >= 0 || host.indexOf(LOCALHOST_2) >= 0)){
			return;
		}
		doManCheck();
	}
	
	/**
	 * 真正判断授权的方法。
	 * @date 2023-12-06 废弃方法，去除任何限制。不过在某些特殊场景下，可以根据情况启用。
	 */
	@Deprecated
	public final void checkMan(){
//		doCheckMan2();
	}
	
	private final void doCheckMan2(){
		man.checkMan();
	}
	
	private final void doManCheck(){
		if(man.manStatus){
			// do nothing...
		}
		Object[] result = (Object[])loader.load();
		if(result == null || result.length != 2){
			man.manStatus = false;
			man.getEating();
		}
		// 从用户配置文件中返回协议结果
		int status = (Integer)result[0];
		if(status == 1){
			man.setMan((byte[])result[1]);
			if(!man.manStatus){
				man.getEating();
			}
		} else {
			System.out.println("-------- load sysLogMan failed!");
			man.getEating();
		}
	}
	
	private static class Man{
		
		private boolean manStatus = false;
		
		private LocalSpider spider = new DefaultLocalSpider();
		
		/**
		 * 设置协议内容。</p>
		 * Mac地址\r\n公匙
		 * @param content
		 */
		public void setMan(byte[] content){
			doCheckMan(content);
		}
		
		private void doCheckMan(byte[] content){
			if(content == null || content.length <= 0){
				return;
			}
			int size = content.length;
//			System.out.println("读取的文件长度 = " + size);
			
			// 消息内容
			ByteBuffer messageBuffer = ByteBuffer.allocate(1024);
			
			ByteBuffer buffer = ByteBuffer.wrap(content);
			byte temp;
			for(int i=0; i<size; i++){
				temp = buffer.get();
				if(((char)temp) != '\n'){
					messageBuffer.put(temp);
				} else {
					break;
				}
			}
			messageBuffer.flip();
			byte[] message = new byte[messageBuffer.remaining()];
			messageBuffer.get(message);
			display("消息体", message);
			
			// 公匙内容
			byte[] publicKeys = new byte[buffer.remaining()];
//			System.out.println("剩余公匙长度，publicKeys: " + publicKeys.length);
			buffer.get(publicKeys);
			display("pk", publicKeys);
			
			try {
				byte[] addressBytes = RSAUtils.decryptByPublicKey(message, new String(publicKeys));
				String source = spider.getMyIdentifier();
				String now = new String(addressBytes);
//				System.out.println("source = " + source + ", now = " + now);
				if(source != null && now != null && source.equals(now)){
//					System.out.println("=========== ok!");
					manStatus = true;
				}
			} catch (Exception e) {
				e.printStackTrace();
				return;
			}
		}
		
		private void getEating(){
			try {
				TimeUnit.SECONDS.sleep(3);
				System.out.println("------> my walker ea logging...");
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		
		private void display(String msg, byte[] bytes){
//			System.out.println(msg + "长度: " + bytes.length);
//			System.out.println(msg + "内容: " + new String(bytes));
		}
		
		//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		// 第二次修改的方法，只有下面的方法是真正的方法。
		//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
		
		private int type = 0;
		private String address;
		private long st = 0;
		private long et = 0;
		
		public void setMan(String[] array){
			doSetMan(array);
		}
		
		private void doSetMan(String[] array){
			if(array == null || array.length != 4){
				throw new IllegalArgumentException();
			}
			type = Integer.parseInt(array[0].toString());
			address = array[1];
			st = Long.parseLong(array[2]);
			et = Long.parseLong(array[3]);
			manStatus = true;
		}

		@Deprecated
		public void checkMan(){
//			doCheckLisence();
		}
		
		private void doCheckLisence(){
			if(manStatus){
				// 已经加载过协议就直接读取，判断
			} else {
				// 还没有加载
				Object[] result = (Object[])loader.load();

//				for (Object o : result){
//					System.out.println(o.toString());
//				}

				if(result == null || result.length != 2)
					throw new SecurityRuntimeException();
				if(!result[0].toString().equals("1")){
					throw new SecurityRuntimeException();
				}
				this.setMan((String[])result[1]);
			}
			if(type == 0){
				// 仅通过ip授权
				doValidateAddress();
				
			} else if(type == 1){
				// 仅通过时间段授权
				doValidateDate();
				
			} else if(type == 2){
				// 两种同时使用
				doValidateAddress();
				doValidateDate();
				
			} else {
				throw new SecurityRuntimeException("unknown authen type: " + type, null);
			}
		}
		
		private boolean doValidateAddress(){
			List<String> addresses = spider.getMyIdentifiers();
//			System.out.println("........... addresses: " + addresses);
			if(addresses != null && addresses.contains(address)){
				// ok
				return true;
			} else {
				throw new SecurityRuntimeException("address error:", null);
			}
		}
		
		private boolean doValidateDate(){
			long _cuTime = System.currentTimeMillis();
			if(_cuTime > st && _cuTime < et){
				return true;
			} else {
				throw new SecurityRuntimeException("date expired:", null);
			}
		}
	}
	
//	public static void main(String[] args){
//		SystemLogMan.getInstance().checkMan();
//	}
}
