/*
 * Decompiled with CFR 0.152.
 */
package com.walker.security;

import com.walker.security.RSAUtils;
import com.walker.security.SecurityRuntimeException;
import com.walker.security.SpiderLoader;
import com.walker.security.util.ClassPathResource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DefaultSpiderLoader
implements SpiderLoader {
    private GenerateCoder generateCoder = new GenerateCoder();
    String[] lisence = null;
    private static final int STATE_OK = 1;
    private static final int STATE_FAILED = 0;

    @Override
    public Object load() {
        return this.doLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] doLoad() {
        Object[] result = new Object[2];
        InputStream inputStream = this.getFile();
        if (inputStream == null) {
            result[0] = 0;
            return result;
        }
        BufferedInputStream bis = new BufferedInputStream(inputStream);
        try {
            int size = bis.available();
            byte[] contentBytes = new byte[size];
            bis.read(contentBytes);
            result[0] = 1;
            result[1] = contentBytes;
            Object[] objectArray = this.generateCoder.readLisenceFile();
            return objectArray;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            result[0] = 0;
            Object[] objectArray = result;
            return objectArray;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private InputStream getFile() {
        ClassPathResource file = new ClassPathResource("wk_sn_lic.bin");
        if (file.exists()) {
            try {
                return file.getInputStream();
            }
            catch (IOException e) {
                throw new SecurityRuntimeException("wk_sn_lic.bin not found!");
            }
        }
        return null;
    }

    private class GenerateCoder {
        private String pk = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCL4fwI6s3zdK0RIDQ0o9xQ7Lq4CoETtOKbDRSCwdCeQ5PrWys4tlenCGOds5SAkOrXFt7wOt0Z33PlAMXpLxAq1gDp/vlOLPPxTfm7S6mUhGNrYOv/0FXQ3rWa7G/UZaXlybn7WLcr2yFaJbwSxxKWa/WuNc1wyCii1S854ZvGBQIDAQAB";

        private GenerateCoder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] readLisenceFile() {
            Object[] result = new Object[2];
            InputStream inputStream = DefaultSpiderLoader.this.getFile();
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            try {
                int size = bis.available();
                byte[] contentBytes = new byte[size];
                bis.read(contentBytes);
                byte[] fileContent = RSAUtils.decryptByPublicKey(contentBytes, this.pk);
                String content = new String(fileContent);
                if (content == null || content.equals("")) {
                    throw new IllegalArgumentException("not found lisence content!");
                }
                String[] props = content.split("\r\n");
                result[0] = 1;
                result[1] = props;
                DefaultSpiderLoader.this.lisence = props;
                Object[] objectArray = result;
                return objectArray;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                result[0] = 0;
                Object[] objectArray = result;
                return objectArray;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

