/*
 * Decompiled with CFR 0.152.
 */
package com.walker.security.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class StringUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static String cleanPath(String path) {
        int i;
        String normalizedPath;
        if (!StringUtils.hasLength(path)) {
            return path;
        }
        String pathToUse = normalizedPath = StringUtils.replace(path, "\\", "/");
        if (normalizedPath.indexOf(46) == -1) {
            return normalizedPath;
        }
        int prefixIndex = normalizedPath.indexOf(58);
        Object prefix = "";
        if (prefixIndex != -1) {
            prefix = normalizedPath.substring(0, prefixIndex + 1);
            if (((String)prefix).contains("/")) {
                prefix = "";
            } else {
                pathToUse = normalizedPath.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith("/")) {
            prefix = (String)prefix + "/";
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.delimitedListToStringArray(pathToUse, "/");
        ArrayDeque<String> pathElements = new ArrayDeque<String>(pathArray.length);
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (".".equals(element)) continue;
            if ("..".equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.addFirst(element);
        }
        if (pathArray.length == pathElements.size()) {
            return normalizedPath;
        }
        for (i = 0; i < tops; ++i) {
            pathElements.addFirst("..");
        }
        if (pathElements.size() == 1 && ((String)pathElements.getLast()).isEmpty() && !((String)prefix).endsWith("/")) {
            pathElements.addFirst(".");
        }
        String joined = StringUtils.collectionToDelimitedString(pathElements, "/");
        return ((String)prefix).isEmpty() ? joined : (String)prefix + joined;
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim, String prefix, String suffix) {
        if (coll == null || coll.size() == 0) {
            return "";
        }
        int totalLength = coll.size() * (prefix.length() + suffix.length()) + (coll.size() - 1) * delim.length();
        for (Object element : coll) {
            totalLength += String.valueOf(element).length();
        }
        StringBuilder sb = new StringBuilder(totalLength);
        Iterator<?> it = coll.iterator();
        while (it.hasNext()) {
            sb.append(prefix).append(it.next()).append(suffix);
            if (!it.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String collectionToDelimitedString(Collection<?> coll, String delim) {
        return StringUtils.collectionToDelimitedString(coll, delim, "", "");
    }

    public static String collectionToCommaDelimitedString(Collection<?> coll) {
        return StringUtils.collectionToDelimitedString(coll, ",");
    }

    public static String[] delimitedListToStringArray(String str, String delimiter) {
        return StringUtils.delimitedListToStringArray(str, delimiter, null);
    }

    public static String[] delimitedListToStringArray(String str, String delimiter, String charsToDelete) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        if (delimiter == null) {
            return new String[]{str};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (delimiter.isEmpty()) {
            for (int pos = 0; pos < str.length(); ++pos) {
                result.add(StringUtils.deleteAny(str.substring(pos, pos + 1), charsToDelete));
            }
        } else {
            int delPos;
            int pos = 0;
            while ((delPos = str.indexOf(delimiter, pos)) != -1) {
                result.add(StringUtils.deleteAny(str.substring(pos, delPos), charsToDelete));
                pos = delPos + delimiter.length();
            }
            if (str.length() > 0 && pos <= str.length()) {
                result.add(StringUtils.deleteAny(str.substring(pos), charsToDelete));
            }
        }
        return StringUtils.toStringArray(result);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection != null && collection.size() > 0 ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static String deleteAny(String inString, String charsToDelete) {
        if (StringUtils.hasLength(inString) && StringUtils.hasLength(charsToDelete)) {
            int lastCharIndex = 0;
            char[] result = new char[inString.length()];
            for (int i = 0; i < inString.length(); ++i) {
                char c = inString.charAt(i);
                if (charsToDelete.indexOf(c) != -1) continue;
                result[lastCharIndex++] = c;
            }
            if (lastCharIndex == inString.length()) {
                return inString;
            }
            return new String(result, 0, lastCharIndex);
        }
        return inString;
    }

    public static String replace(String inString, String oldPattern, String newPattern) {
        if (StringUtils.hasLength(inString) && StringUtils.hasLength(oldPattern) && newPattern != null) {
            int index = inString.indexOf(oldPattern);
            if (index == -1) {
                return inString;
            }
            int capacity = inString.length();
            if (newPattern.length() > oldPattern.length()) {
                capacity += 16;
            }
            StringBuilder sb = new StringBuilder(capacity);
            int pos = 0;
            int patLen = oldPattern.length();
            while (index >= 0) {
                sb.append(inString, pos, index);
                sb.append(newPattern);
                pos = index + patLen;
                index = inString.indexOf(oldPattern, pos);
            }
            sb.append(inString, pos, inString.length());
            return sb.toString();
        }
        return inString;
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }
}

