/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.kaptcha;

import com.google.code.kaptcha.impl.DefaultKaptcha;
import com.google.code.kaptcha.util.Config;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import java.awt.image.BufferedImage;
import java.util.Properties;

public class SimpleKaptchaProvider
implements CaptchaProvider<CaptchaResult> {
    private DefaultKaptcha textKaptcha = this.createTextKaptcha();
    private DefaultKaptcha mathKaptcha = this.createMathKaptcha();
    private static final String CAPTCHA_TYPE_CHAR = "char";
    private static final String CAPTCHA_TYPE_MATH = "math";

    public CaptchaResult generateCaptcha(Object param) {
        CaptchaResult captchaResult = null;
        String capStr = null;
        String code = null;
        BufferedImage image = null;
        if (param != null && param.toString().equals(CAPTCHA_TYPE_MATH)) {
            String capText = this.mathKaptcha.createText();
            capStr = capText.substring(0, capText.lastIndexOf("@"));
            code = capText.substring(capText.lastIndexOf("@") + 1);
            image = this.mathKaptcha.createImage(capStr);
            captchaResult = new CaptchaResult();
            captchaResult.setCode(code);
            captchaResult.setImage(image);
            return captchaResult;
        }
        capStr = code = this.textKaptcha.createText();
        image = this.textKaptcha.createImage(capStr);
        captchaResult = new CaptchaResult();
        captchaResult.setCode(code);
        captchaResult.setImage(image);
        return captchaResult;
    }

    public boolean validateCaptcha(CaptchaResult data) {
        return false;
    }

    public CaptchaType getCaptchaType() {
        return CaptchaType.InputCode;
    }

    private DefaultKaptcha createTextKaptcha() {
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        Properties properties = new Properties();
        properties.setProperty("kaptcha.border", "yes");
        properties.setProperty("kaptcha.textproducer.font.color", "black");
        properties.setProperty("kaptcha.image.width", "160");
        properties.setProperty("kaptcha.image.height", "60");
        properties.setProperty("kaptcha.textproducer.font.size", "38");
        properties.setProperty("kaptcha.session.key", "kaptchaCode");
        properties.setProperty("kaptcha.textproducer.char.length", "4");
        properties.setProperty("kaptcha.textproducer.font.names", "Arial,Courier");
        properties.setProperty("kaptcha.obscurificator.impl", "com.google.code.kaptcha.impl.ShadowGimpy");
        Config config = new Config(properties);
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }

    private DefaultKaptcha createMathKaptcha() {
        DefaultKaptcha defaultKaptcha = new DefaultKaptcha();
        Properties properties = new Properties();
        properties.setProperty("kaptcha.border", "yes");
        properties.setProperty("kaptcha.border.color", "105,179,90");
        properties.setProperty("kaptcha.textproducer.font.color", "blue");
        properties.setProperty("kaptcha.image.width", "160");
        properties.setProperty("kaptcha.image.height", "60");
        properties.setProperty("kaptcha.textproducer.font.size", "35");
        properties.setProperty("kaptcha.session.key", "kaptchaCodeMath");
        properties.setProperty("kaptcha.textproducer.impl", "com.walker.support.kaptcha.KaptchaTextCreator");
        properties.setProperty("kaptcha.textproducer.char.space", "3");
        properties.setProperty("kaptcha.textproducer.char.length", "6");
        properties.setProperty("kaptcha.textproducer.font.names", "Arial,Courier");
        properties.setProperty("kaptcha.noise.color", "white");
        properties.setProperty("kaptcha.noise.impl", "com.google.code.kaptcha.impl.NoNoise");
        properties.setProperty("kaptcha.obscurificator.impl", "com.google.code.kaptcha.impl.ShadowGimpy");
        Config config = new Config(properties);
        defaultKaptcha.setConfig(config);
        return defaultKaptcha;
    }
}

