/*
 * Decompiled with CFR 0.152.
 */
package com.walker.support.kaptcha;

import com.walker.infrastructure.utils.StringUtils;
import com.walker.web.CaptchaProvider;
import com.walker.web.CaptchaResult;
import com.walker.web.CaptchaType;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Random;

public class WordCaptchaProvider
implements CaptchaProvider<CaptchaResult> {
    private static final Random random = new Random();
    private final int width = 80;
    private final int height = 34;
    private final int stringNum = 4;
    private final int lineSize = 40;

    public CaptchaResult generateCaptcha(Object param) {
        CaptchaResult captchaResult = new CaptchaResult();
        BufferedImage image = this.createImage(captchaResult);
        captchaResult.setImage(image);
        return captchaResult;
    }

    public boolean validateCaptcha(CaptchaResult data) {
        return false;
    }

    public CaptchaType getCaptchaType() {
        return CaptchaType.InputCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage createImage(CaptchaResult captchaResult) {
        Graphics Graphics2 = null;
        try {
            BufferedImage image = new BufferedImage(80, 34, 4);
            Graphics2 = image.getGraphics();
            Graphics2.fillRect(0, 0, 80, 34);
            Graphics2.setFont(new Font("Times New Roman", 0, 18));
            Graphics2.setColor(this.getRandColor(110, 133));
            for (int i = 0; i <= 40; ++i) {
                this.drawLine(Graphics2);
            }
            String randomString = "";
            for (int i = 1; i <= 4; ++i) {
                randomString = this.drawString(Graphics2, randomString, i);
                captchaResult.setCode(randomString);
            }
            BufferedImage bufferedImage = image;
            return bufferedImage;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BufferedImage bufferedImage = null;
            return bufferedImage;
        }
        finally {
            if (Graphics2 != null) {
                Graphics2.dispose();
            }
        }
    }

    private String drawString(Graphics graphics, String randomString, int i) {
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setFont(this.getFont());
        g2d.setColor(new Color(random.nextFloat(), random.nextFloat(), random.nextFloat()));
        String randChar = this.getRandomChar(random.nextInt("0123456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ".length()));
        randomString = (String)randomString + randChar;
        int rot = Integer.parseInt(StringUtils.generateRandomNumber((int)1));
        g2d.translate(random.nextInt(3), random.nextInt(3));
        g2d.rotate((double)rot * Math.PI / 180.0);
        g2d.drawString(randChar, 13 * i, 20);
        g2d.rotate((double)(-rot) * Math.PI / 180.0);
        return randomString;
    }

    private void drawLine(Graphics graphics) {
        int x = random.nextInt(80);
        int y = random.nextInt(34);
        int xl = random.nextInt(13);
        int yl = random.nextInt(15);
        graphics.setColor(new Color(random.nextFloat(), random.nextFloat(), random.nextFloat()));
        graphics.drawLine(x, y, x + xl, y + yl);
    }

    private Font getFont() {
        return new Font("Fixedsys", 1, 25);
    }

    private String getRandomChar(int index) {
        return String.valueOf("0123456789abcdefghjkmnpqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ".charAt(index));
    }

    private Color getRandColor(int frontColor, int backColor) {
        if (frontColor > 255) {
            frontColor = 255;
        }
        if (backColor > 255) {
            backColor = 255;
        }
        int red = frontColor + random.nextInt(backColor - frontColor - 16);
        int green = frontColor + random.nextInt(backColor - frontColor - 14);
        int blue = frontColor + random.nextInt(backColor - frontColor - 18);
        return new Color(red, green, blue);
    }
}

